/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.EFNClientConfig;
import com.hm.efn.client.events.ScreenEffectEngine;
import com.hm.efn.client.screeneffect.HsvFilterEffect;
import com.hm.efn.gameasset.combos.Bloodlust;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.hm.efn.skill.EFNWeaponInnateBase;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BloodlustInnate
extends EFNWeaponInnateBase {
    private static final UUID DODGE_TRIGGER_UUID = UUID.fromString("e5f6a1b2-c8d1-11ed-a51b-0242ac120019");

    public BloodlustInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public void updateContainer(SkillContainer container) {
        if (container.getExecutor().isLogicalClient() && ((Boolean)EFNClientConfig.ENABLE_BLOODLUST_POSTEFFECT.get()).booleanValue()) {
            HsvFilterEffect effect = new HsvFilterEffect(((Player)container.getExecutor().getOriginal()).f_19825_, 20, ((Player)container.getExecutor().getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.BLODDLUST.get()));
            ScreenEffectEngine.PushScreenEffectADD(effect);
        }
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > 7) {
            this.resetCombo(container, (PlayerPatch)container.getServerExecutor(), this.root);
        }
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID, event -> {
            PlayerPatch patt2781$temp;
            if (event.getSkillContainer().getSkill() instanceof DodgeSkill && (patt2781$temp = container.getExecutor()) instanceof ServerPlayerPatch) {
                ServerPlayerPatch playerPatch = (ServerPlayerPatch)patt2781$temp;
                ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
                if (this.isHoldingWeapon(container)) {
                    player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Bloodlust.DodgeCounter));
                }
            }
        });
    }

    private boolean isHoldingWeapon(SkillContainer container) {
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this;
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        String keyName = Component.m_237115_((String)InvincibleKeyMappings.KEY3.m_90860_()).getString();
        list.add(Component.m_237115_((String)"skill.efn.bloodlust.tooltip").m_130940_(ChatFormatting.RED));
        list.add(Component.m_237115_((String)"skill.efn.bloodlust.tooltip1").m_7220_((Component)Component.m_237113_((String)keyName)).m_130946_(": ").m_130940_(ChatFormatting.RED).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.bloodlust.tooltip2"));
        return list;
    }
}

