/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.EFNClientConfig;
import com.hm.efn.client.events.ScreenEffectEngine;
import com.hm.efn.client.screeneffect.RedColorEffect;
import com.hm.efn.gameasset.combos.Beastclaw;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.hm.efn.skill.EFNWeaponInnateBase;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BeastclawInnate
extends EFNWeaponInnateBase {
    private static final UUID DODGE_TRIGGER_UUID = UUID.fromString("e5f6a1b2-c8d1-11ed-a05b-0242ac120018");
    private static final UUID STAMINA_REDUCTION_UUID = UUID.fromString("4074c6de-0268-11ee-be56-0242ac120003");

    public BeastclawInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public void updateContainer(SkillContainer container) {
        if (container.getExecutor().isLogicalClient() && ((Boolean)EFNClientConfig.ENABLE_BEASTCLAW_POSTEFFECT.get()).booleanValue()) {
            RedColorEffect effect = new RedColorEffect(((Player)container.getExecutor().getOriginal()).f_19825_, 600, ((Player)container.getExecutor().getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.CLAW.get()), 0.28f);
            ScreenEffectEngine.PushScreenEffect(effect);
        }
        super.updateContainer(container);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID, event -> {
            ServerPlayerPatch playerPatch;
            ServerPlayer player;
            PlayerPatch patt2773$temp;
            if (event.getSkillContainer().getSkill() instanceof DodgeSkill && (patt2773$temp = container.getExecutor()) instanceof ServerPlayerPatch && this.isHoldingFist(player = (ServerPlayer)(playerPatch = (ServerPlayerPatch)patt2773$temp).getOriginal())) {
                player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Beastclaw.DodgeCounter));
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, STAMINA_REDUCTION_UUID, event -> {
            if (event.getSkill() instanceof DodgeSkill && ((Player)container.getExecutor().getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.CLAW.get())) {
                event.setAmount(event.getAmount() * 0.5f);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID);
        listener.removeListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, STAMINA_REDUCTION_UUID);
        if (container.getExecutor().isLogicalClient()) {
            RedColorEffect effect = new RedColorEffect(((Player)container.getExecutor().getOriginal()).f_19825_, 600, ((Player)container.getExecutor().getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.CLAW.get()), 0.08f);
            ScreenEffectEngine.RemoveScreenEffect(effect);
        }
    }

    private boolean isHoldingFist(ServerPlayer player) {
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == CapabilityItem.WeaponCategories.FIST);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        String keyName = Component.m_237115_((String)InvincibleKeyMappings.KEY3.m_90860_()).getString();
        list.add(Component.m_237115_((String)"skill.efn.beastclaw.tooltip").m_130940_(ChatFormatting.YELLOW));
        list.add(Component.m_237115_((String)"skill.efn.beastclaw.tooltip1").m_7220_((Component)Component.m_237113_((String)keyName)).m_130946_(": ").m_130940_(ChatFormatting.YELLOW).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.beastclaw.tooltip2"));
        return list;
    }
}

