/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.arts;

import com.hm.efn.EFNCommonConfig;
import com.hm.efn.client.input.keymapping.EFNKeyMappings;
import com.hm.efn.gameasset.EFNAnimations;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.EFNSkillCategories;
import com.hm.efn.gameasset.EFNWeaponCategories;
import com.hm.efn.gameasset.combos.Yamato;
import com.hm.efn.item.custom.YamatoItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class JudgmentCutEndSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a416c93a-42cb-11eb-b378-0242ac170003");
    private int cooldown;

    public JudgmentCutEndSkill(Builder builder) {
        super((SkillBuilder)builder);
    }

    public static Builder createJudgmentCutEndBuilder() {
        return (Builder)new Builder().setCategory(EFNSkillCategories.JUDGMENTCUT_END).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public static boolean isHoldingYamato(Player player) {
        if (player == null) {
            return false;
        }
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == EFNWeaponCategories.EFN_YAMATO);
    }

    public static boolean isYamatoUnlocked(Player player) {
        if (!((Boolean)EFNCommonConfig.YAMATO_REWARD_ENABLED.get()).booleanValue()) {
            return false;
        }
        int rewardThreshold = (Integer)EFNCommonConfig.YAMATO_REWARD_KILL_THRESHOLD.get();
        if (rewardThreshold <= 0) {
            return false;
        }
        for (ItemStack itemStack : new ItemStack[]{player.m_21205_(), player.m_21206_()}) {
            int killCount;
            if (!(itemStack.m_41720_() instanceof YamatoItem) || (killCount = YamatoItem.getKillCount(itemStack)) < rewardThreshold) continue;
            return true;
        }
        return false;
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.cooldown = parameters.m_128451_("cooldown");
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        Player player = (Player)executer.getOriginal();
        boolean onGround = player.m_20096_();
        boolean holdingYamato = JudgmentCutEndSkill.isHoldingYamato(player);
        if (player.m_7500_()) {
            return onGround && holdingYamato;
        }
        boolean cooldownReady = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get()) <= 0;
        boolean yamatoUnlocked = JudgmentCutEndSkill.isYamatoUnlocked(player);
        return onGround && holdingYamato && yamatoUnlocked && cooldownReady;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        if (container.getExecutor().isLogicalClient()) {
            container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> this.handleKeyInput(container));
        }
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        int currentCooldown;
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient()) {
            this.handleKeyInput(container);
        }
        if ((currentCooldown = ((Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get())).intValue()) > 0) {
            container.getDataManager().setData((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)(currentCooldown - 1));
        }
    }

    private void handleKeyInput(SkillContainer container) {
        if (EFNKeyMappings.EFN_ARTS.m_90857_()) {
            CPSkillRequest packet = new CPSkillRequest((SkillSlot)SkillSlot.ENUM_MANAGER.get(container.getSlot().universalOrdinal()), CPSkillRequest.WorkType.CAST);
            EpicFightNetworkManager.sendToServer((Object)packet);
        }
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        container.getDataManager().setDataSync((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)this.cooldown);
        container.getServerExecutor().playAnimationSynchronized(EFNAnimations.DMC5_V_JC, 0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        SkillContainer yamatoSkillContainer = executor.getSkill(Yamato.yamato);
        return yamatoSkillContainer != null && yamatoSkillContainer.hasSkill() && (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)((Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get())).intValue() / 20.0), x + 2.0f, y + 8.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(EFNKeyMappings.EFN_ARTS.m_90863_());
        list.add((double)this.cooldown / 20.0);
        return list;
    }

    public static class Builder
    extends SkillBuilder<JudgmentCutEndSkill> {
    }
}

