/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@Mod.EventBusSubscriber(modid="efn")
public class MeenLance {
    private static final UUID ARMOR_NEGATION_UUID = UUID.fromString("b0a7436e-5734-11eb-ae93-0242ac130003");
    private static final UUID IMPACT_UUID = UUID.fromString("b0a745b2-5734-11eb-ae93-0242ac130003");
    private static final UUID STUN_ARMOR_UUID = UUID.fromString("b0a746ac-5734-11eb-ae93-0242ac130003");
    private static final UUID STAMINA_REGEN_UUID = UUID.fromString("1c224694-19f3-11ec-9621-0242ac130003");
    private static final UUID DAMAGE_UUID = UUID.fromString("1c2249f0-19f3-11ec-9621-0242ac130003");
    private static final double MULTIPLIER = 1.45;
    private static final double MULTIPLIER_MINUS_ONE = 0.44999999999999996;

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof MeenLanceEffect) {
            ((MeenLanceEffect)event.getEffectInstance().m_19544_()).applyModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof MeenLanceEffect) {
            ((MeenLanceEffect)event.getEffect()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (Objects.requireNonNull(event.getEffectInstance()).m_19544_() instanceof MeenLanceEffect) {
            ((MeenLanceEffect)event.getEffectInstance().m_19544_()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Player && event.getSlot() == EquipmentSlot.MAINHAND && event.getEntity().m_21023_((MobEffect)EFNMobEffectRegistry.MEEN_LANCE.get())) {
            event.getEntity().m_21195_((MobEffect)EFNMobEffectRegistry.MEEN_LANCE.get());
        }
    }

    public static class MeenLanceEffect
    extends MobEffect {
        public MeenLanceEffect() {
            super(MobEffectCategory.NEUTRAL, 0xFFFFFF);
        }

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (!entity.m_9236_().m_5776_()) {
                this.applyModifiers(entity);
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        private void applyModifiers(LivingEntity entity) {
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), ARMOR_NEGATION_UUID, "MeenLance Armor Negation");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.IMPACT.get(), IMPACT_UUID, "MeenLance Impact");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.STUN_ARMOR.get(), STUN_ARMOR_UUID, "MeenLance Stun Armor");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID, "MeenLance Stamina Regen");
            this.safeAddModifier(entity, Attributes.f_22281_, DAMAGE_UUID, "MeenLance Damage");
        }

        private void removeModifiers(LivingEntity entity) {
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), ARMOR_NEGATION_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.IMPACT.get(), IMPACT_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.STUN_ARMOR.get(), STUN_ARMOR_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID);
            this.safeRemoveModifier(entity, Attributes.f_22281_, DAMAGE_UUID);
        }

        private void safeAddModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name) {
            if (entity.m_21051_(attribute) != null) {
                AttributeModifier modifier = new AttributeModifier(uuid, name, 0.44999999999999996, AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (!Objects.requireNonNull(entity.m_21051_(attribute)).m_22109_(modifier)) {
                    Objects.requireNonNull(entity.m_21051_(attribute)).m_22118_(modifier);
                }
            }
        }

        private void safeRemoveModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
            if (entity.m_21051_(attribute) != null) {
                Objects.requireNonNull(entity.m_21051_(attribute)).m_22120_(uuid);
            }
        }
    }
}

