/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="efn")
public class KnockBackResistanceEffect {
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("a5d8a7e1-5734-11eb-ae93-0242ac130002");

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof ResistanceEffect) {
            ((ResistanceEffect)event.getEffectInstance().m_19544_()).addResistanceModifier(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof ResistanceEffect) {
            ((ResistanceEffect)event.getEffect()).removeResistanceModifier(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (Objects.requireNonNull(event.getEffectInstance()).m_19544_() instanceof ResistanceEffect) {
            ((ResistanceEffect)event.getEffectInstance().m_19544_()).removeResistanceModifier(event.getEntity());
        }
    }

    public static class ResistanceEffect
    extends MobEffect {
        public ResistanceEffect() {
            super(MobEffectCategory.NEUTRAL, 0x5A5AFF);
        }

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (!entity.m_9236_().m_5776_()) {
                this.addResistanceModifier(entity);
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        private void addResistanceModifier(LivingEntity entity) {
            if (entity.m_21051_(Attributes.f_22278_) != null) {
                AttributeModifier modifier = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Knockback Resistance", 1.0, AttributeModifier.Operation.ADDITION);
                if (!Objects.requireNonNull(entity.m_21051_(Attributes.f_22278_)).m_22109_(modifier)) {
                    Objects.requireNonNull(entity.m_21051_(Attributes.f_22278_)).m_22118_(modifier);
                }
            }
        }

        private void removeResistanceModifier(LivingEntity entity) {
            if (entity.m_21051_(Attributes.f_22278_) != null) {
                Objects.requireNonNull(entity.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_UUID);
            }
        }
    }
}

