/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.item.custom;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DuskFireArmorItem
extends ArmorItem {
    private static final ArmorMaterial DUSKFIRE_MATERIAL = new ArmorMaterial(){

        public int m_266425_(ArmorItem.Type type) {
            return -1;
        }

        public int m_7366_(ArmorItem.Type type) {
            return (new int[]{7, 11, 13, 7})[type.m_266308_().m_20749_()];
        }

        public int m_6646_() {
            return 50;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11679_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_151265_();
        }

        @NotNull
        public String m_6082_() {
            return "duskfire";
        }

        public float m_6651_() {
            return 8.0f;
        }

        public float m_6649_() {
            return 0.2f;
        }
    };

    public DuskFireArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(DUSKFIRE_MATERIAL, type, properties.m_41497_(Rarity.EPIC).m_41486_());
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        super.onArmorTick(stack, level, player);
        if (!level.m_5776_()) {
            this.applyIndividualFireResistance(player, stack);
        }
    }

    private void applyIndividualFireResistance(Player player, ItemStack armorStack) {
        int fireTicks;
        if (player.m_20094_() > 0 && (fireTicks = player.m_20094_()) > 20) {
            player.m_7311_(fireTicks - 1);
        }
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public static class Boots
    extends DuskFireArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/duskfirearmor.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_FEET || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }

        public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.efn.duskfire_armor.description1"));
        }
    }

    public static class Leggings
    extends DuskFireArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/duskfirearmor.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_LEGS || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }

        public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.efn.duskfire_armor.description1"));
        }
    }

    public static class Chestplate
    extends DuskFireArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/duskfirearmor.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_CHEST || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }

        public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.efn.duskfire_armor.description1"));
        }
    }

    public static class Helmet
    extends DuskFireArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/duskfirearmor.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_HEAD || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }

        public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.efn.duskfire_armor.description1"));
        }
    }
}

