/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.doppelganger;

import com.hm.efn.client.sound.EFNSounds;
import com.hm.efn.entity.EFNEntity;
import com.hm.efn.entity.doppelganger.DoppelgangerPatch;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.EFNWeaponCategories;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class DoppelgangerEntity
extends TamableAnimal {
    private static final double OFFSET_DISTANCE = 1.25;
    private static final int CHECK_COOLDOWN_TICKS = 10;
    private final Random random = new Random();
    @Nullable
    private PlayerPatch<?> ownerPatch;
    private Vec3 lastOwnerPosition;
    private int currentSide = -1;
    private int checkCooldown = 0;

    public DoppelgangerEntity(ServerPlayer owner) {
        super((EntityType)EFNEntity.DOPPELGANGER.get(), owner.m_9236_());
        this.m_21828_((Player)owner);
        this.m_21530_();
        this.currentSide = this.random.nextBoolean() ? 1 : -1;
    }

    public DoppelgangerEntity(EntityType<DoppelgangerEntity> doppelgangerEntityEntityType, Level level) {
        super(doppelgangerEntityEntityType, level);
    }

    public static AttributeSupplier getDefaultAttribute() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 9.99999999E8).m_22268_(Attributes.f_22281_, 10.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 6.0).m_22265_();
    }

    private static boolean isHoldingYamato(LivingEntity player) {
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == EFNWeaponCategories.EFN_YAMATO);
    }

    public static void summon(ServerPlayerPatch serverPlayerPatch) {
        if (!DoppelgangerEntity.isHoldingYamato((LivingEntity)serverPlayerPatch.getOriginal())) {
            return;
        }
        DoppelgangerEntity doppelganger = new DoppelgangerEntity((ServerPlayer)serverPlayerPatch.getOriginal());
        Vec3 vec3 = ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20182_();
        doppelganger.m_20219_(new Vec3(vec3.f_82479_ + 1.0, vec3.f_82480_, vec3.f_82481_));
        ((ServerPlayer)serverPlayerPatch.getOriginal()).m_284548_().m_7967_((Entity)doppelganger);
        serverPlayerPatch.playSound((SoundEvent)EFNSounds.DOPPELGANGER_OPEN.get(), 1.0f, 1.0f, 1.0f);
        DoppelgangerEntity.spawnDarkParticles(((ServerPlayer)serverPlayerPatch.getOriginal()).m_284548_(), ((ServerPlayer)serverPlayerPatch.getOriginal()).m_20182_());
    }

    public static void spawnDarkParticles(ServerLevel level, Vec3 position) {
        SimpleParticleType particle = ParticleTypes.f_123762_;
        int count = 50;
        double speed = 0.1;
        double spread = 0.5;
        level.m_8767_((ParticleOptions)particle, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, count, spread, spread, spread, speed);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, 20, 0.3, 0.3, 0.3, 0.2);
        DoppelgangerEntity.spawnCircularParticles(level, position);
    }

    public static void spawnCircularParticles(ServerLevel level, Vec3 position) {
        SimpleParticleType particle = ParticleTypes.f_123755_;
        int circleParticles = 20;
        double radius = 1.5;
        double height = 2.0;
        for (int i = 0; i < circleParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)circleParticles;
            double x = position.f_82479_ + radius * Math.cos(angle);
            double z = position.f_82481_ + radius * Math.sin(angle);
            double y = position.f_82480_ + height;
            level.m_8767_((ParticleOptions)particle, x, y, z, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }

    @Nullable
    public PlayerPatch<?> getOwnerPatch() {
        if (this.ownerPatch != null) {
            return this.ownerPatch;
        }
        if (this.m_269323_() != null) {
            this.ownerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)this.m_269323_(), PlayerPatch.class);
            return this.ownerPatch;
        }
        return null;
    }

    public void m_7334_(Entity pEntity) {
    }

    protected void m_6138_() {
    }

    protected void m_7324_(@NotNull Entity p_20971_) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_142391_() {
        return true;
    }

    public void m_21828_(@NotNull Player player) {
        super.m_21828_(player);
        this.m_8061_(EquipmentSlot.MAINHAND, player.m_6844_(EquipmentSlot.MAINHAND).m_41777_());
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_27568_) {
        return false;
    }

    public boolean m_142066_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_269323_() == null || !this.m_269323_().m_6084_() || this.m_269323_().m_21223_() <= 0.0f) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!DoppelgangerEntity.isHoldingYamato(this.m_269323_()) && !this.m_269323_().m_9236_().m_5776_()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)this.m_269323_(), ServerPlayerPatch.class);
            serverPlayerPatch.playSound((SoundEvent)EFNSounds.DOPPELGANGER_CLOSE.get(), 1.0f, 1.0f, 1.0f);
            DoppelgangerEntity.spawnDarkParticles(((ServerPlayer)serverPlayerPatch.getOriginal()).m_284548_(), this.m_20182_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        LivingEntity owner = this.m_269323_();
        --this.checkCooldown;
        if (this.checkCooldown <= 0) {
            this.checkAndAdjustSide(owner);
            this.checkCooldown = 10;
        }
        this.m_21557_(true);
        this.synchronizeWithOwner(owner);
        this.preventBlockCollision();
    }

    private void synchronizeWithOwner(LivingEntity owner) {
        Vec3 offset = this.calculateOffsetPosition(owner);
        Vec3 targetPosition = owner.m_20182_().m_82549_(offset);
        SkillContainer skill = this.getOwnerPatch().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        int style = skill.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.DOPPELGANGER_STYLE.get()) == null ? 0 : (Integer)skill.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.DOPPELGANGER_STYLE.get());
        switch (style) {
            case 1: {
                this.m_6034_(this.lerp(this.m_20185_(), targetPosition.f_82479_, 0.9), this.lerp(this.m_20186_(), targetPosition.f_82480_, 0.9), this.lerp(this.m_20189_(), targetPosition.f_82481_, 0.9));
                break;
            }
            case 0: {
                if (((DoppelgangerPatch)EpicFightCapabilities.getEntityPatch((Entity)this, DoppelgangerPatch.class)).getEntityState().turningLocked() || this.getOwnerPatch().getEntityState().turningLocked()) break;
                if (this.lastOwnerPosition == null) {
                    this.lastOwnerPosition = new Vec3(this.m_269323_().m_20185_(), this.m_269323_().m_20186_(), this.m_269323_().m_20189_());
                }
                Vec3 delta = this.m_269323_().m_20182_().m_82546_(this.lastOwnerPosition);
                this.m_6478_(MoverType.SELF, delta);
                break;
            }
        }
        DoppelgangerPatch doppelgangerPatch = (DoppelgangerPatch)EpicFightCapabilities.getEntityPatch((Entity)this, DoppelgangerPatch.class);
        if (!doppelgangerPatch.getEntityState().turningLocked()) {
            this.f_19860_ = owner.f_19860_;
            this.f_19859_ = owner.f_19859_;
            this.m_146922_(owner.m_146908_());
            this.m_146926_(owner.m_146909_());
            this.m_5616_(owner.m_6080_());
            this.f_20883_ = owner.f_20883_;
        } else if (doppelgangerPatch.getTarget() != null) {
            ((DoppelgangerEntity)doppelgangerPatch.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(doppelgangerPatch.getTarget().m_20185_(), doppelgangerPatch.getTarget().m_20188_() + 0.1, doppelgangerPatch.getTarget().m_20189_()));
        }
        this.m_20260_(owner.m_6144_());
        this.m_6858_(owner.m_20142_());
        this.m_20282_(owner.m_6069_());
        this.m_20256_(owner.m_20184_());
        this.m_7910_(owner.m_6113_());
        this.m_20124_(owner.m_20089_());
        this.lastOwnerPosition = owner.m_20182_();
        double TPDistance = skill.getDataManager().hasData((SkillDataKey)EFNSKillDataKeys.DOPPELGANGER_DELAY.get()) && skill.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.DOPPELGANGER_DELAY.get()) != null && (Boolean)skill.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.DOPPELGANGER_DELAY.get()) != false ? 15 : 12;
        if ((double)this.m_20270_((Entity)this.m_269323_()) > TPDistance) {
            this.m_6021_(this.lastOwnerPosition.f_82479_ + 1.0, this.lastOwnerPosition.f_82480_, this.lastOwnerPosition.f_82481_);
        }
    }

    private void checkAndAdjustSide(LivingEntity owner) {
        Vec3 currentOffset = this.calculateOffsetPosition(owner);
        Vec3 currentPos = owner.m_20182_().m_82549_(currentOffset);
        if (this.isPositionBlocked(currentPos)) {
            this.currentSide *= -1;
            Vec3 oppositeOffset = this.calculateOffsetForSide(owner, this.currentSide);
            Vec3 oppositePos = owner.m_20182_().m_82549_(oppositeOffset);
            if (this.isPositionBlocked(oppositePos)) {
                this.tryFindValidPosition(owner);
            }
        }
    }

    private void tryFindValidPosition(LivingEntity owner) {
        for (double distance = 0.5; distance <= 2.0; distance += 0.5) {
            Vec3 offset = this.calculateOffsetForSideWithDistance(owner, this.currentSide, distance);
            Vec3 testPos = owner.m_20182_().m_82549_(offset);
            if (this.isPositionBlocked(testPos)) continue;
            return;
        }
        this.currentSide = this.random.nextBoolean() ? 1 : -1;
    }

    private Vec3 calculateOffsetPosition(LivingEntity owner) {
        return this.calculateOffsetForSideWithDistance(owner, this.currentSide, 1.25);
    }

    private Vec3 calculateOffsetForSide(LivingEntity owner, int side) {
        return this.calculateOffsetForSideWithDistance(owner, side, 1.25);
    }

    private Vec3 calculateOffsetForSideWithDistance(LivingEntity owner, int side, double distance) {
        double yawRad = Math.toRadians(owner.m_146908_());
        double angleOffset = side == 1 ? 1.5707963267948966 : -1.5707963267948966;
        double offsetX = -Math.sin(yawRad + angleOffset) * distance;
        double offsetZ = Math.cos(yawRad + angleOffset) * distance;
        return new Vec3(offsetX, 0.0, offsetZ);
    }

    private boolean isPositionBlocked(Vec3 position) {
        BlockPos blockPos = BlockPos.m_274446_((Position)position);
        BlockPos blockPosAbove = blockPos.m_7494_();
        boolean currentBlocked = !this.m_9236_().m_46859_(blockPos);
        boolean aboveBlocked = !this.m_9236_().m_46859_(blockPosAbove);
        return currentBlocked || aboveBlocked;
    }

    private double lerp(double start, double end, double factor) {
        return start + (end - start) * factor;
    }

    private void preventBlockCollision() {
        BlockPos currentPos = this.m_20183_();
        if (!this.m_9236_().m_46859_(currentPos)) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_());
        }
    }
}

