/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class IsStunnedCondition
implements Condition<ServerPlayerPatch> {
    private final Set<StunType> requiredStunTypes;
    private final boolean shouldBeStunned;

    public IsStunnedCondition(boolean shouldBeStunned, StunType ... stunTypes) {
        this.shouldBeStunned = shouldBeStunned;
        this.requiredStunTypes = new HashSet<StunType>();
        this.requiredStunTypes.addAll(Arrays.asList(stunTypes));
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        boolean shouldBeStunned = compoundTag.m_128471_("shouldBeStunned");
        String[] typeNames = compoundTag.m_128461_("stunTypes").split(",");
        StunType[] types = new StunType[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            types[i] = StunType.valueOf(typeNames[i]);
        }
        return new IsStunnedCondition(shouldBeStunned, types);
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("shouldBeStunned", this.shouldBeStunned);
        StringBuilder sb = new StringBuilder();
        for (StunType type : this.requiredStunTypes) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(type.name());
        }
        tag.m_128359_("stunTypes", sb.toString());
        return tag;
    }

    public boolean predicate(ServerPlayerPatch playerPatch) {
        if (playerPatch == null) {
            return false;
        }
        Animator animator = playerPatch.getAnimator();
        boolean isStunned = this.checkStunnedAnimations(animator);
        return this.shouldBeStunned == isStunned;
    }

    private boolean checkStunnedAnimations(Animator animator) {
        if (this.requiredStunTypes.isEmpty()) {
            return this.checkAnimation(animator, (AnimationPlayer)Animations.BIPED_HIT_LONG) || this.checkAnimation(animator, (AnimationPlayer)Animations.BIPED_HIT_SHORT) || this.checkAnimation(animator, (AnimationPlayer)Animations.BIPED_KNOCKDOWN) || this.checkAnimation(animator, (AnimationPlayer)Animations.BIPED_COMMON_NEUTRALIZED) || this.checkAnimation(animator, (AnimationPlayer)Animations.BIPED_LANDING);
        }
        for (StunType type : this.requiredStunTypes) {
            if (!this.checkAnimation(animator, type.getAnimation())) continue;
            return true;
        }
        return false;
    }

    private boolean checkAnimation(Animator animator, AnimationPlayer targetAnim) {
        if (targetAnim == null) {
            return false;
        }
        AnimationPlayer currentPlayer = animator.getPlayerFor(targetAnim.getAnimation());
        return currentPlayer != null && currentPlayer.getAnimation() == targetAnim.getAnimation() && !currentPlayer.isEnd();
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }

    public static enum StunType {
        HIT_LONG((AnimationPlayer)Animations.BIPED_HIT_LONG),
        HIT_SHORT((AnimationPlayer)Animations.BIPED_HIT_SHORT),
        KNOCKDOWN((AnimationPlayer)Animations.BIPED_KNOCKDOWN),
        NEUTRALIZED((AnimationPlayer)Animations.BIPED_COMMON_NEUTRALIZED),
        LANDING((AnimationPlayer)Animations.BIPED_LANDING);

        private final AnimationPlayer animation;

        private StunType(AnimationPlayer animation) {
            this.animation = animation;
        }

        public AnimationPlayer getAnimation() {
            return this.animation;
        }
    }
}

