/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import com.hm.efn.gameasset.EFNSKillDataKeys;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class ComboCounterCondition
implements Condition<ServerPlayerPatch> {
    private float minTime;
    private float maxTime;

    public ComboCounterCondition(float minTime, float maxTime) {
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("minTime") && compoundTag.m_128441_("maxTime")) {
            this.minTime = compoundTag.m_128457_("minTime");
            this.maxTime = compoundTag.m_128457_("maxTime");
            return this;
        }
        throw new IllegalArgumentException("ComboCounterCondition requires both minTime and maxTime parameters");
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("minTime", this.minTime);
        tag.m_128350_("maxTime", this.maxTime);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch playerPatch) {
        if (playerPatch == null || playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE) == null) {
            return false;
        }
        SkillDataManager dataManager = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager();
        Float counter = (Float)dataManager.getDataValue((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get());
        if (counter == null) {
            return false;
        }
        return counter.floatValue() >= this.minTime && counter.floatValue() <= this.maxTime;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

