/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class ClawAirborneCondition
implements Condition<ServerPlayerPatch> {
    private final boolean strictMode;
    private final float minAirborneDistance;

    public ClawAirborneCondition() {
        this(true, 0.0f);
    }

    public ClawAirborneCondition(boolean strictMode, float minAirborneDistance) {
        this.strictMode = strictMode;
        this.minAirborneDistance = minAirborneDistance;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        boolean strict = !compoundTag.m_128441_("strictMode") || compoundTag.m_128471_("strictMode");
        float distance = compoundTag.m_128441_("minDistance") ? compoundTag.m_128457_("minDistance") : 0.0f;
        return new ClawAirborneCondition(strict, distance);
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("strictMode", this.strictMode);
        tag.m_128350_("minDistance", this.minAirborneDistance);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        Player player = (Player)serverPlayerPatch.getOriginal();
        if (player.m_20096_()) {
            return false;
        }
        return !this.strictMode || this.checkStrictAirborne(player) && this.checkAirborneDistance(player);
    }

    private boolean checkStrictAirborne(Player player) {
        return !player.m_20069_() && !player.m_6147_() && !player.m_20159_() && !player.m_21255_() && !player.m_20077_() && !player.m_150110_().f_35935_;
    }

    private boolean checkAirborneDistance(Player player) {
        BlockState blockState;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(player.m_20185_(), player.m_20186_() - 0.1, player.m_20189_());
        int searchDepth = 0;
        do {
            blockState = player.m_9236_().m_8055_((BlockPos)pos);
            pos.m_122184_(0, -1, 0);
        } while ((blockState.m_60795_() || blockState.m_60734_() instanceof BushBlock) && ++searchDepth < 10);
        float distance = (float)(player.m_20186_() - (double)pos.m_123342_() - 1.0);
        return distance >= this.minAirborneDistance;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

