/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.render.screens.devil;

import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@OnlyIn(value=Dist.CLIENT)
public class DevilRenderEvent {
    private static final ResourceLocation DEVIL_BOUND = ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/gui/devil_bound.png");
    private static final ResourceLocation DEVIL_FILL = ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/gui/devil_fill.png");
    private static final ResourceLocation DEVIL_LIQUID = ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/gui/devil_liquid.png");
    private static final int IMAGE_WIDTH = 96;
    private static final int IMAGE_HEIGHT = 26;
    private static final int MARGIN = 32;

    @SubscribeEvent
    public static void onRenderDevilBar(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)mc.f_91074_, LocalPlayerPatch.class);
        if (localPlayerPatch == null) {
            return;
        }
        SkillContainer container = localPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        if (container == null || !container.getDataManager().hasData((SkillDataKey)EFNSKillDataKeys.DOPPELGANGER_TICK.get())) {
            return;
        }
        int stack = container.getStack();
        float resourceRatio = container.getResource() / container.getMaxResource();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int posX = screenWidth - 96 - 32 + 16;
        int posY = screenHeight - 26 - 32;
        guiGraphics.m_280163_(DEVIL_BOUND, posX, posY, 0.0f, 0.0f, 96, 26, 96, 26);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < stack; ++i) {
            int px = i >= 5 ? (i - 5) * 13 : i * 13;
            int py = i >= 5 ? 6 : 0;
            guiGraphics.m_280163_(DEVIL_FILL, posX + 21 + px, posY + 10 + py, (float)(21 + px), 10.0f, 12, 5, 96, 26);
        }
        int px = stack >= 5 ? (stack - 5) * 13 : stack * 13;
        int py = stack >= 5 ? 6 : 0;
        int totalPix = Math.round(5.0f * resourceRatio);
        guiGraphics.m_280163_(DEVIL_FILL, posX + 21 + px, posY + 10 + py + (5 - totalPix), 21.0f, (float)(10 + py + (5 - totalPix)), 12, totalPix, 96, 26);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

