/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.render;

import com.google.common.collect.Maps;
import com.hm.efn.client.render.custom.AirDisturbanceRenderType;
import com.hm.efn.client.render.custom.BloomParticleRenderType;
import com.hm.efn.client.render.custom.BloomTrailRenderType;
import com.hm.efn.client.render.custom.MeshSpaceBrokenRenderType;
import com.hm.efn.client.render.custom.SpaceBrokenRenderType;
import com.hm.efn.client.render.custom.SpaceTrailRenderType;
import com.hm.efn.client.render.custom.SubMaskRenderType;
import com.hm.efn.client.render.custom.SubSpaceRenderType;
import com.hm.efn.util.OjangUtils;
import com.hm.efn.util.RenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.HashMap;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EFNRenderType {
    public static final ResourceLocation WHITE = ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/particle/white.png");
    public static final HashMap<ResourceLocation, BloomParticleRenderType> BloomRenderTypes = Maps.newHashMap();
    public static final HashMap<ResourceLocation, EFNQuadParticleRenderType> QuadRenderTypes = Maps.newHashMap();
    public static final HashMap<ResourceLocation, EFNTriangleParticleRenderType> TriangleRenderTypes = Maps.newHashMap();
    public static final ResourceLocation NoneTexture = RenderUtils.GetTexture("none");
    public static final ParticleRenderType TRANSLUCENT = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::m_172835_);
            RenderUtils.GLSetTexture(NoneTexture);
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return "EFN:TRANSLUCENT";
        }
    };
    private static final int spaceIdx = 0;
    public static BloomParticleRenderType BLOOM_POSITION_COLOR_LIGHTMAP = new BloomParticleRenderType(OjangUtils.newRL("efn", "b_fpcl"), WHITE){

        @Override
        public void setupBufferBuilder(BufferBuilder bufferBuilder) {
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85816_);
        }

        @Override
        protected ShaderInstance getShader() {
            return GameRenderer.f_172587_;
        }
    };
    public static SpaceBrokenRenderType SpaceBroken1 = new SpaceBrokenRenderType(OjangUtils.newRL("efn", "space_broken"), 0);
    public static SpaceBrokenRenderType SpaceBroken2 = new SpaceBrokenRenderType(OjangUtils.newRL("efn", "space_broken"), 1);
    public static SpaceBrokenRenderType SpaceBrokenEnd = new SpaceBrokenRenderType(OjangUtils.newRL("efn", "space_broken_end"), RenderUtils.GetTexture("particle/glass"), 0, 4);
    public static SpaceTrailRenderType SpaceBrokenTrail = new SpaceTrailRenderType(OjangUtils.newRL("efn", "space_broken_end"), RenderUtils.GetTexture("particle/glass2"), 1, 4);
    public static AirDisturbanceRenderType AirDisturbanceTrail = new AirDisturbanceRenderType(OjangUtils.newRL("efn", "air_trail"), 0.2f, 0.1f, 1.0f, 0.0f, 0.5f);
    public static MeshSpaceBrokenRenderType MeshSpaceBrokenEnd = new MeshSpaceBrokenRenderType(OjangUtils.newRL("efn", "space_broken_end"), RenderUtils.GetTexture("particle/glass"), 0, 4);
    public static SubMaskRenderType SubMask = new SubMaskRenderType(OjangUtils.newRL("efn", "sub_mask"), RenderUtils.GetTexture("none"));
    public static SubSpaceRenderType SubSpace_BlackHole = new SubSpaceRenderType(OjangUtils.newRL("efn", "sub_space"), RenderUtils.GetTexture("none"));
    private static int bloomIdx = 0;
    private static int quadIdx = 0;
    private static int triangleIdx = 0;

    public static BloomParticleRenderType getBloomRenderTypeByTexture(ResourceLocation texture) {
        if (BloomRenderTypes.containsKey(texture)) {
            return BloomRenderTypes.get(texture);
        }
        BloomParticleRenderType bloomType = new BloomParticleRenderType(OjangUtils.newRL("efn", "bp_" + bloomIdx++), texture);
        BloomRenderTypes.put(texture, bloomType);
        return bloomType;
    }

    public static BloomTrailRenderType getBloomTrailRT(ResourceLocation texture) {
        if (BloomRenderTypes.containsKey(texture)) {
            return (BloomTrailRenderType)BloomRenderTypes.get(texture);
        }
        BloomTrailRenderType bloomType = new BloomTrailRenderType(OjangUtils.newRL("efn", "bt_" + bloomIdx++), texture);
        BloomRenderTypes.put(texture, bloomType);
        return bloomType;
    }

    public static EFNQuadParticleRenderType getRenderTypeByTexture(ResourceLocation texture) {
        if (QuadRenderTypes.containsKey(texture)) {
            return QuadRenderTypes.get(texture);
        }
        EFNQuadParticleRenderType rdt = new EFNQuadParticleRenderType("efn:quad_particle_" + quadIdx++, texture);
        QuadRenderTypes.put(texture, rdt);
        return rdt;
    }

    public static EFNTriangleParticleRenderType getTriangleRenderTypeByTexture(ResourceLocation texture) {
        if (TriangleRenderTypes.containsKey(texture)) {
            return TriangleRenderTypes.get(texture);
        }
        EFNTriangleParticleRenderType rdt = new EFNTriangleParticleRenderType("efn:triangle_particle_" + triangleIdx++, texture);
        TriangleRenderTypes.put(texture, rdt);
        return rdt;
    }

    public static ShaderInstance getPositionColorLightmapShader() {
        return GameRenderer.f_172587_;
    }

    public static ShaderInstance getPositionColorTexShader() {
        return GameRenderer.f_172588_;
    }

    public static class EFNQuadParticleRenderType
    implements ParticleRenderType {
        private final ResourceLocation Texture;
        private final String Name;

        public EFNQuadParticleRenderType(String name, ResourceLocation tex) {
            this.Texture = tex;
            this.Name = name;
        }

        public void m_6505_(BufferBuilder p_107448_, TextureManager p_107449_) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172829_);
            if (this.Texture != null) {
                RenderUtils.GLSetTexture(this.Texture);
            }
            p_107448_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return this.Name;
        }
    }

    public static class EFNTriangleParticleRenderType
    implements ParticleRenderType {
        private final ResourceLocation Texture;
        private final String Name;

        public EFNTriangleParticleRenderType(String name, ResourceLocation tex) {
            this.Texture = tex;
            this.Name = name;
        }

        public void m_6505_(@NotNull BufferBuilder p_107448_, @NotNull TextureManager p_107449_) {
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172835_);
            if (this.Texture != null) {
                RenderUtils.GLSetTexture(this.Texture);
            }
            p_107448_.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return this.Name;
        }
    }
}

