/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.input;

import com.hm.efn.client.input.keymapping.EFNKeyMappings;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.skill.EFNWeaponInnateBase;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class LongPressKeyHandler {
    public static final int LONG_PRESS_THRESHOLD = 4;
    private static final int KEY_COUNT = 5;
    private static final int SYNC_INTERVAL = 2;
    private static final BitSet currentPressed = new BitSet(5);
    private static final BitSet lastPressed = new BitSet(5);
    private static final int[] pressTicks = new int[5];
    private static final Supplier<int[]> KEY_MAPPINGS = () -> new int[]{InvincibleKeyMappings.KEY1.getKey().m_84873_(), InvincibleKeyMappings.KEY2.getKey().m_84873_(), InvincibleKeyMappings.KEY3.getKey().m_84873_(), InvincibleKeyMappings.KEY4.getKey().m_84873_(), EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey().m_84873_()};
    private static final KeyState[] keyStates = new KeyState[5];
    private static int syncCounter = 0;

    @SubscribeEvent
    public static void onInputEvent(InputEvent event) {
        if (event instanceof InputEvent.Key) {
            InputEvent.Key keyEvent = (InputEvent.Key)event;
            LongPressKeyHandler.handleKeyInput(keyEvent.getKey(), keyEvent.getAction());
        } else if (event instanceof InputEvent.MouseButton.Pre) {
            InputEvent.MouseButton.Pre mouseEvent = (InputEvent.MouseButton.Pre)event;
            LongPressKeyHandler.handleKeyInput(mouseEvent.getButton(), mouseEvent.getAction());
        } else if (event instanceof InputEvent.MouseScrollingEvent) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch == null || !LongPressKeyHandler.hasRequiredWeapon((LivingEntity)playerPatch.getOriginal())) {
            return;
        }
        LongPressKeyHandler.updateKeyStates(playerPatch);
        if (LongPressKeyHandler.shouldSyncStates()) {
            LongPressKeyHandler.syncKeyStates(playerPatch);
        }
        if (playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof ComboBasicAttack) {
            SkillDataManager manager = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager();
            Options options = Minecraft.m_91087_().f_91066_;
            LongPressKeyHandler.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)EFNSKillDataKeys.DEMON_KEY.get()), EFNKeyMappings.DEMON);
            LongPressKeyHandler.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)EFNSKillDataKeys.ANGEL_KEY.get()), EFNKeyMappings.ANGEL);
            LongPressKeyHandler.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)EFNSKillDataKeys.SPRINT_KEY.get()), options.f_92091_);
            LongPressKeyHandler.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)EFNSKillDataKeys.JUMP_KEY.get()), options.f_92089_);
            LongPressKeyHandler.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)EFNSKillDataKeys.UP_KEY.get()), options.f_92085_);
            LongPressKeyHandler.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)EFNSKillDataKeys.DOWN_KEY.get()), options.f_92087_);
            LongPressKeyHandler.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)EFNSKillDataKeys.SNEAK_KEY.get()), options.f_92090_);
        }
        lastPressed.clear();
        lastPressed.or(currentPressed);
    }

    private static void checkDirectionKeyDown(SkillDataManager manager, SkillDataKey<Boolean> skillDataKey, KeyMapping key) {
        if (((Boolean)manager.getDataValue(skillDataKey)).booleanValue() != key.m_90857_()) {
            manager.setDataSync(skillDataKey, (Object)key.m_90857_());
        }
    }

    public static boolean hasRequiredWeapon(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, PlayerPatch.class);
        if (playerPatch == null) {
            return false;
        }
        return playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof EFNWeaponInnateBase;
    }

    private static void updateKeyStates(LocalPlayerPatch playerPatch) {
        SkillDataManager manager = LongPressKeyHandler.getDataManager(playerPatch);
        if (manager == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            boolean current = currentPressed.get(i);
            boolean last = lastPressed.get(i);
            if (!current) {
                if (keyStates[i] != KeyState.RELEASED) {
                    LongPressKeyHandler.keyStates[i] = pressTicks[i] < 4 ? KeyState.JUST_RELEASED : KeyState.RELEASED;
                    LongPressKeyHandler.pressTicks[i] = 0;
                }
            } else {
                int n = i;
                pressTicks[n] = pressTicks[n] + 1;
                KeyState keyState = LongPressKeyHandler.keyStates[i] = pressTicks[i] >= 4 ? KeyState.LONG_PRESSED : KeyState.PRESSED;
            }
            if (current == last && keyStates[i] != KeyState.LONG_PRESSED || !LongPressKeyHandler.isDataKeyRegistered(manager, i)) continue;
            manager.setData(KeySuppliers.PRESS[i].get(), (Object)current);
            manager.setData(KeySuppliers.TIMER[i].get(), (Object)pressTicks[i]);
            manager.setData(KeySuppliers.LONG_PRESS[i].get(), (Object)(keyStates[i] == KeyState.LONG_PRESSED ? 1 : 0));
        }
    }

    private static boolean isDataKeyRegistered(SkillDataManager manager, int index) {
        return manager.hasData(KeySuppliers.PRESS[index].get()) && manager.hasData(KeySuppliers.TIMER[index].get()) && manager.hasData(KeySuppliers.LONG_PRESS[index].get());
    }

    private static boolean shouldSyncStates() {
        return ++syncCounter >= 2 || !currentPressed.equals(lastPressed);
    }

    private static void syncKeyStates(LocalPlayerPatch playerPatch) {
        syncCounter = 0;
        SkillDataManager manager = LongPressKeyHandler.getDataManager(playerPatch);
        if (manager == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (currentPressed.get(i) == lastPressed.get(i) && keyStates[i] != KeyState.LONG_PRESSED || !LongPressKeyHandler.isDataKeyRegistered(manager, i)) continue;
            manager.setDataSync(KeySuppliers.PRESS[i].get(), (Object)currentPressed.get(i));
            manager.setDataSync(KeySuppliers.TIMER[i].get(), (Object)pressTicks[i]);
            manager.setDataSync(KeySuppliers.LONG_PRESS[i].get(), (Object)(keyStates[i] == KeyState.LONG_PRESSED ? 1 : 0));
        }
    }

    private static void handleKeyInput(int keyCode, int action) {
        int[] mappings = KEY_MAPPINGS.get();
        for (int i = 0; i < mappings.length; ++i) {
            if (keyCode != mappings[i]) continue;
            currentPressed.set(i, action != 0);
            break;
        }
    }

    private static SkillDataManager getDataManager(LocalPlayerPatch playerPatch) {
        SkillContainer container = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        return container != null ? container.getDataManager() : null;
    }

    public static boolean isKeyPressed(int index) {
        return index >= 0 && index < 5 && currentPressed.get(index);
    }

    public static int getPressTicks(int index) {
        return index >= 0 && index < 5 ? pressTicks[index] : 0;
    }

    public static KeyState getKeyState(int index) {
        return index >= 0 && index < 5 ? keyStates[index] : KeyState.RELEASED;
    }

    public static boolean isLongPressed(int index) {
        return LongPressKeyHandler.getKeyState(index) == KeyState.LONG_PRESSED;
    }

    public static boolean wasShortPressed(int index) {
        return LongPressKeyHandler.getKeyState(index) == KeyState.JUST_RELEASED;
    }

    static {
        Arrays.fill((Object[])keyStates, (Object)KeyState.RELEASED);
    }

    public static enum KeyState {
        RELEASED,
        PRESSED,
        LONG_PRESSED,
        JUST_RELEASED;

    }

    private static final class KeySuppliers {
        private static final Supplier<SkillDataKey<Boolean>>[] PRESS = KeySuppliers.createSuppliers(EFNSKillDataKeys::getKeyPress);
        private static final Supplier<SkillDataKey<Integer>>[] TIMER = KeySuppliers.createSuppliers(EFNSKillDataKeys::getKeyPressTimer);
        private static final Supplier<SkillDataKey<Boolean>>[] LONG_PRESS = KeySuppliers.createSuppliers(EFNSKillDataKeys::getKeyLongPress);

        private KeySuppliers() {
        }

        private static <T> Supplier<SkillDataKey<T>>[] createSuppliers(Function<Integer, SkillDataKey<T>> factory) {
            Supplier[] suppliers = new Supplier[5];
            for (int i = 0; i < 5; ++i) {
                int index = i + 1;
                suppliers[i] = () -> (SkillDataKey)factory.apply(index);
            }
            return suppliers;
        }
    }
}

