/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.events;

import com.google.common.collect.Sets;
import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.client.screeneffect.ScreenEffectBase;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="efn", value={Dist.CLIENT})
public class ScreenEffectEngine {
    static Set<ScreenEffectBase> effects = Sets.newConcurrentHashSet();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void OnRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            float partialTicks = event.getPartialTick();
            effects.forEach(e -> {
                if (e.shouldPost(event.getCamera(), event.getFrustum())) {
                    PostEffectPipelines.Pipeline patt1255$temp = e.getPipeline();
                    if (patt1255$temp instanceof ScreenEffectBase.SE_Pipeline) {
                        ScreenEffectBase.SE_Pipeline sePipeline = (ScreenEffectBase.SE_Pipeline)patt1255$temp;
                        sePipeline.setPartialTicks(partialTicks);
                    }
                    PostEffectPipelines.PostEffectQueue.add(e.getPipeline());
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            effects.forEach(ScreenEffectBase::tick);
            effects.removeIf(ScreenEffectBase::shouldRemoved);
        }
    }

    public static void RemoveScreenEffect(ScreenEffectBase screenEffect) {
        ScreenEffectEngine.effects.removeIf(effects -> effects.ID.equals((Object)screenEffect.ID));
    }

    public static void PushScreenEffect(ScreenEffectBase screenEffect) {
        ScreenEffectEngine.effects.removeIf(effects -> effects.ID.equals((Object)screenEffect.ID));
        ScreenEffectEngine.effects.add(screenEffect);
    }

    public static void PushScreenEffectADD(ScreenEffectBase screenEffect) {
        effects.add(screenEffect);
    }

    public static void PushScreenEffectADD2(ScreenEffectBase screenEffect) {
        for (ScreenEffectBase effect : effects) {
            if (!effect.ID.equals((Object)screenEffect.ID) || effect.lifetime <= 3) continue;
            return;
        }
        effects.add(screenEffect);
    }
}

