/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.capability;

import com.hm.efn.EFN;
import com.hm.efn.capability.EFNCapabilities;
import com.hm.efn.capability.murasama.network.S2CMurasamaDodgeCapPacket;
import com.hm.efn.capability.murasama.network.S2CMurasamaGuardCapPacket;
import com.hm.efn.capability.yamato.network.S2CYamatoDodgeCapPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="efn", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EFNCapabilityHandler {
    public static void syncCaps(ServerPlayer player) {
        player.getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CYamatoDodgeCapPacket(cap.serializeNBT())));
        player.getCapability(EFNCapabilities.MURASAMA_GUARD_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CMurasamaGuardCapPacket(cap.serializeNBT())));
        player.getCapability(EFNCapabilities.MURASAMA_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CMurasamaDodgeCapPacket(cap.serializeNBT())));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> event.getEntity().getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap2 -> cap2.deserializeNBT(cap.serializeNBT())));
        event.getOriginal().getCapability(EFNCapabilities.MURASAMA_GUARD_CAP).ifPresent(cap -> event.getEntity().getCapability(EFNCapabilities.MURASAMA_GUARD_CAP).ifPresent(cap2 -> cap2.deserializeNBT(cap.serializeNBT())));
        event.getOriginal().getCapability(EFNCapabilities.MURASAMA_DODGE_CAP).ifPresent(cap -> event.getEntity().getCapability(EFNCapabilities.MURASAMA_DODGE_CAP).ifPresent(cap2 -> cap2.deserializeNBT(cap.serializeNBT())));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNCapabilityHandler.syncCaps(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNCapabilityHandler.syncCaps(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNCapabilityHandler.syncCaps(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer targetPlayer = (ServerPlayer)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer trackingPlayer = (ServerPlayer)entity;
                targetPlayer.getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> trackingPlayer), (Object)new S2CYamatoDodgeCapPacket(cap.serializeNBT())));
                targetPlayer.getCapability(EFNCapabilities.MURASAMA_GUARD_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> trackingPlayer), (Object)new S2CMurasamaGuardCapPacket(cap.serializeNBT())));
                targetPlayer.getCapability(EFNCapabilities.MURASAMA_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> trackingPlayer), (Object)new S2CMurasamaDodgeCapPacket(cap.serializeNBT())));
            }
        }
    }

    public static void syncYamatoDodgeCap(ServerPlayer player) {
        player.getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CYamatoDodgeCapPacket(cap.serializeNBT())));
    }

    public static void syncMurasamaGuardCap(ServerPlayer player) {
        player.getCapability(EFNCapabilities.MURASAMA_GUARD_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CMurasamaGuardCapPacket(cap.serializeNBT())));
    }

    public static void syncMurasamaDodgeCap(ServerPlayer player) {
        player.getCapability(EFNCapabilities.MURASAMA_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CMurasamaDodgeCapPacket(cap.serializeNBT())));
    }

    public static void syncCapsToTrackingPlayers(ServerPlayer player) {
        player.getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new S2CYamatoDodgeCapPacket(cap.serializeNBT())));
        player.getCapability(EFNCapabilities.MURASAMA_GUARD_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new S2CMurasamaGuardCapPacket(cap.serializeNBT())));
        player.getCapability(EFNCapabilities.MURASAMA_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new S2CMurasamaDodgeCapPacket(cap.serializeNBT())));
    }
}

