/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.animations.types.vfx;

import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class VFXBBAnimation
extends ActionAnimation {
    protected float[] bakedTimes = new float[this.getAnimationClip().getJointTransform("Root").getKeyframes().length];

    public VFXBBAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        int index = 0;
        for (Keyframe kf : this.getAnimationClip().getJointTransform("Root").getKeyframes()) {
            this.bakedTimes[index] = kf.time();
            ++index;
        }
    }

    public Pose getRawPoseWithoutInterpolate(float time) {
        Pose pose = new Pose();
        int begin = 0;
        int end = this.bakedTimes.length - 1;
        while (end - begin > 1) {
            int i = begin + (end - begin) / 2;
            if (this.bakedTimes[i] <= time && this.bakedTimes[i + 1] > time) {
                begin = i;
                end = i + 1;
                break;
            }
            if (this.bakedTimes[i] > time) {
                end = i;
                continue;
            }
            if (!(this.bakedTimes[i + 1] <= time)) continue;
            begin = i;
        }
        for (String jointName : this.animationClip.getJointTransforms().keySet()) {
            JointTransform jt = ((TransformSheet)this.animationClip.getJointTransforms().get(jointName)).getKeyframes()[begin].transform().copy();
            pose.putJointData(jointName, jt);
        }
        return pose;
    }

    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        partialTicks = 0.0f;
        Pose pose = this.getRawPoseWithoutInterpolate(time);
        this.modifyPose((DynamicAnimation)this, pose, entitypatch, time, partialTicks);
        return pose;
    }

    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        partialTicks = 0.0f;
        super.modifyPose(animation, pose, entitypatch, time, partialTicks);
    }
}

