/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface SlotReference {
    public static final Empty EMPTY = new Empty();
    public static final CodecMapRegistry<SlotReference> REGISTRY = (CodecMapRegistry)Util.m_137537_(() -> {
        CodecMapRegistry m = new CodecMapRegistry("slot_reference");
        m.register("hand", Hand.CODEC);
        m.register("inv", Inv.CODEC);
        m.register("empty", Empty.CODEC);
        m.register("eq_slot", EqSlot.CODEC);
        m.register("quiver", Quiver.CODEC);
        return m;
    });
    public static final Codec<SlotReference> STREAM_CODEC = REGISTRY.dispatch(SlotReference::getCodec, c -> c);

    default public Item getItem(LivingEntity player) {
        return this.get(player).m_41720_();
    }

    public ItemStack get(LivingEntity var1);

    public static SlotReference hand(InteractionHand pUsedHand) {
        return new Hand(pUsedHand);
    }

    public static SlotReference slot(EquipmentSlot equipmentSlot) {
        return new EqSlot(equipmentSlot);
    }

    public static SlotReference inv(int invSlot) {
        return new Inv(invSlot);
    }

    @NotNull
    public static SlotReference quiver(IQuiverEntity e) {
        return Quiver.INSTANCE;
    }

    default public boolean isEmpty() {
        return this == EMPTY;
    }

    public Codec<? extends SlotReference> getCodec();

    public static SlotReference decode(FriendlyByteBuf buf) {
        return (SlotReference)((Pair)STREAM_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).getOrThrow(false, e -> Supplementaries.error("Failed to decode slot reference: " + e, new Object[0]))).getFirst();
    }

    public static void encode(FriendlyByteBuf buf, SlotReference slotReference) {
        buf.m_130079_((CompoundTag)STREAM_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)slotReference).getOrThrow(false, e -> Supplementaries.error("Failed to encode slot reference: " + e, new Object[0])));
    }

    public record Hand(InteractionHand hand) implements SlotReference
    {
        public static final Codec<Hand> CODEC = Codec.BOOL.xmap(b -> b != false ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, h -> h == InteractionHand.MAIN_HAND).xmap(Hand::new, Hand::hand);

        @Override
        public ItemStack get(LivingEntity player) {
            return player.m_21120_(this.hand);
        }

        public Codec<Hand> getCodec() {
            return CODEC;
        }
    }

    public record EqSlot(EquipmentSlot slot) implements SlotReference
    {
        public static final Codec<EqSlot> CODEC = Codec.INT.xmap(i -> EquipmentSlot.values()[0], Enum::ordinal).xmap(EqSlot::new, EqSlot::slot);

        @Override
        public ItemStack get(LivingEntity player) {
            return player.m_6844_(this.slot);
        }

        public Codec<EqSlot> getCodec() {
            return CODEC;
        }
    }

    public record Inv(int invSlot) implements SlotReference
    {
        public static final Codec<Inv> CODEC = Codec.INT.xmap(Inv::new, Inv::invSlot);

        @Override
        public ItemStack get(LivingEntity player) {
            return player.m_141942_(this.invSlot).m_142196_();
        }

        public Codec<Inv> getCodec() {
            return CODEC;
        }
    }

    public record Quiver() implements SlotReference
    {
        private static final Quiver INSTANCE = new Quiver();
        private static final Codec<Quiver> CODEC = Codec.unit((Object)INSTANCE);

        @Override
        public ItemStack get(LivingEntity player) {
            if (player instanceof Player) {
                Player p = (Player)player;
                return QuiverItem.findActiveQuiver((LivingEntity)p);
            }
            return ItemStack.f_41583_;
        }

        public Codec<Quiver> getCodec() {
            return CODEC;
        }
    }

    public record Empty() implements SlotReference
    {
        public static final Codec<Empty> CODEC = Codec.unit((Object)EMPTY);

        @Override
        public ItemStack get(LivingEntity player) {
            return ItemStack.f_41583_;
        }

        public Codec<Empty> getCodec() {
            return CODEC;
        }
    }
}

