/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.sdf.operator;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.util.Mth;
import org.betterx.bclib.sdf.operator.SDFDisplacement;

public class SDFHeightmap
extends SDFDisplacement {
    private float intensity = 1.0f;
    private NativeImage map;
    private float offsetX;
    private float offsetZ;
    private float scale;
    private float cos = 1.0f;
    private float sin = 0.0f;

    public SDFHeightmap() {
        this.setFunction(pos -> {
            if (this.map == null) {
                return Float.valueOf(0.0f);
            }
            float px = Mth.m_14036_((float)(pos.x() * this.scale + this.offsetX), (float)0.0f, (float)(this.map.m_84982_() - 2));
            float pz = Mth.m_14036_((float)(pos.z() * this.scale + this.offsetZ), (float)0.0f, (float)(this.map.m_85084_() - 2));
            float dx = px * this.cos - pz * this.sin;
            float dz = pz * this.cos + px * this.sin;
            int x1 = Mth.m_14143_((float)dx);
            int z1 = Mth.m_14143_((float)dz);
            int x2 = x1 + 1;
            int z2 = z1 + 1;
            dx -= (float)x1;
            dz -= (float)z1;
            float a = (float)(this.map.m_84985_(x1, z1) & 0xFF) / 255.0f;
            float b = (float)(this.map.m_84985_(x2, z1) & 0xFF) / 255.0f;
            float c = (float)(this.map.m_84985_(x1, z2) & 0xFF) / 255.0f;
            float d = (float)(this.map.m_84985_(x2, z2) & 0xFF) / 255.0f;
            a = Mth.m_14179_((float)dx, (float)a, (float)b);
            b = Mth.m_14179_((float)dx, (float)c, (float)d);
            return Float.valueOf(-Mth.m_14179_((float)dz, (float)a, (float)b) * this.intensity);
        });
    }

    public SDFHeightmap setMap(NativeImage map) {
        this.map = map;
        this.offsetX = (float)map.m_84982_() * 0.5f;
        this.offsetZ = (float)map.m_85084_() * 0.5f;
        this.scale = map.m_84982_();
        return this;
    }

    public SDFHeightmap setAngle(float angle) {
        this.sin = Mth.m_14031_((float)angle);
        this.cos = Mth.m_14089_((float)angle);
        return this;
    }

    public SDFHeightmap setScale(float scale) {
        this.scale = (float)this.map.m_84982_() * scale;
        return this;
    }

    public SDFHeightmap setIntensity(float intensity) {
        this.intensity = intensity;
        return this;
    }
}

