/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.recipes.AbstractBaseRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;

public class CraftingRecipeBuilder
extends AbstractBaseRecipeBuilder<CraftingRecipeBuilder> {
    private String[] shape;
    private boolean showNotification = true;
    protected final Map<String, CriterionTriggerInstance> unlocks = new HashMap<String, CriterionTriggerInstance>();
    protected final Map<Character, Ingredient> materials = new HashMap<Character, Ingredient>();

    protected CraftingRecipeBuilder(ResourceLocation id, ItemLike output) {
        super(id, output);
        this.shape = new String[]{"#"};
    }

    static CraftingRecipeBuilder make(ResourceLocation id, ItemLike output) {
        return new CraftingRecipeBuilder(id, output);
    }

    @Override
    public CraftingRecipeBuilder setOutputCount(int count) {
        return (CraftingRecipeBuilder)super.setOutputCount(count);
    }

    public CraftingRecipeBuilder addMaterial(char key, TagKey<Item> value) {
        this.unlockedBy((TagKey)value);
        this.materials.put(Character.valueOf(key), Ingredient.m_204132_(value));
        return this;
    }

    public CraftingRecipeBuilder addMaterial(char key, ItemStack ... values) {
        this.unlockedBy(values);
        return this.addMaterial(key, Ingredient.m_43921_(Arrays.stream(values)));
    }

    public CraftingRecipeBuilder addMaterial(char key, ItemLike ... values) {
        for (ItemLike item : values) {
            this.alright &= BCLRecipeManager.exists(item);
        }
        this.unlockedBy(values);
        return this.addMaterial(key, Ingredient.m_43929_((ItemLike[])values));
    }

    private CraftingRecipeBuilder addMaterial(char key, Ingredient value) {
        this.materials.put(Character.valueOf(key), value);
        return this;
    }

    public CraftingRecipeBuilder setShape(String ... shape) {
        this.shape = shape;
        return this;
    }

    public CraftingRecipeBuilder shapeless() {
        this.shape = null;
        return this;
    }

    @Deprecated(forRemoval=true)
    public CraftingRecipeBuilder setList(String shape) {
        return this.shapeless();
    }

    public CraftingRecipeBuilder showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(ItemLike item) {
        return (CraftingRecipeBuilder)super.unlockedBy(item);
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(TagKey<Item> tag) {
        return (CraftingRecipeBuilder)super.unlockedBy(tag);
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(ItemLike ... items) {
        return (CraftingRecipeBuilder)super.unlockedBy(items);
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(ItemStack ... stacks) {
        return (CraftingRecipeBuilder)super.unlockedBy(stacks);
    }

    @Override
    protected CraftingRecipeBuilder unlocks(String name, CriterionTriggerInstance trigger) {
        this.unlocks.put(name, trigger);
        return this;
    }

    @Override
    public CraftingRecipeBuilder setGroup(String group) {
        return (CraftingRecipeBuilder)super.setGroup(group);
    }

    @Override
    protected boolean checkRecipe() {
        if (this.shape != null) {
            return this.checkShaped();
        }
        return this.checkShapeless();
    }

    @Override
    protected void buildRecipe(Consumer<FinishedRecipe> cc) {
        if (this.shape != null) {
            this.buildShaped(cc);
        } else {
            this.buildShapeless(cc);
        }
    }

    protected boolean checkShapeless() {
        if (this.materials.size() == 0) {
            BCLib.LOGGER.warning("Recipe {} does not contain a material!", this.id);
            return false;
        }
        return super.checkRecipe();
    }

    protected void buildShapeless(Consumer<FinishedRecipe> cc) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)this.category, (ItemLike)this.output.m_41720_(), (int)this.output.m_41613_());
        for (Map.Entry<String, CriterionTriggerInstance> entry : this.unlocks.entrySet()) {
            builder.m_126132_(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.materials.entrySet()) {
            builder.m_126184_((Ingredient)entry.getValue());
        }
        builder.m_126145_(this.group);
        builder.m_126140_(cc, this.id);
    }

    protected boolean checkShaped() {
        int i;
        if (this.shape == null || this.shape.length == 0) {
            BCLib.LOGGER.warning("Recipe {} does not contain a shape!", this.id);
            return false;
        }
        if (this.shape.length > 3) {
            BCLib.LOGGER.warning("Recipe {} shape contains more than three lines!", this.id);
            return false;
        }
        int width = this.shape[0].length();
        if (width > 3) {
            BCLib.LOGGER.warning("Recipe {} shape is wider than three!", this.id);
            return false;
        }
        Object allLines = "";
        for (i = 0; i < this.shape.length; ++i) {
            if (this.shape[i].length() != width) {
                BCLib.LOGGER.warning("All lines in the shape of Recipe {} should be the same length!", this.id);
                return false;
            }
            allLines = (String)allLines + this.shape[i];
        }
        if (((String)(allLines = ((String)allLines).replaceAll(" ", ""))).length() == 1) {
            BCLib.LOGGER.warning("Recipe {} only takes in a single item and should be shapeless", this.id);
            return false;
        }
        for (i = 0; i < ((String)allLines).length(); ++i) {
            char c = ((String)allLines).charAt(i);
            if (this.materials.containsKey(Character.valueOf(c))) continue;
            BCLib.LOGGER.warning("Recipe {} is missing the material definition for '" + c + "'!", this.id);
            return false;
        }
        return super.checkRecipe();
    }

    protected void buildShaped(Consumer<FinishedRecipe> cc) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)this.category, (ItemLike)this.output.m_41720_(), (int)this.output.m_41613_());
        for (Map.Entry<String, CriterionTriggerInstance> entry : this.unlocks.entrySet()) {
            builder.m_126132_(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.materials.entrySet()) {
            builder.m_126124_((Character)entry.getKey(), (Ingredient)entry.getValue());
        }
        for (Iterator<Map.Entry<Object, Object>> iterator : this.shape) {
            builder.m_126130_(iterator);
        }
        builder.m_126145_(this.group);
        builder.m_271710_(this.showNotification);
        builder.m_126140_(cc, this.id);
    }
}

