/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;

public interface SurfaceMaterialProvider {
    public static final Codec<SurfaceMaterialProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("top").forGetter(o -> o.getTopMaterial()), (App)BlockState.f_61039_.fieldOf("under").forGetter(o -> o.getUnderMaterial()), (App)BlockState.f_61039_.fieldOf("alt").forGetter(o -> o.getAltTopMaterial()), (App)Codec.BOOL.fieldOf("floor_rule").forGetter(o -> o.generateFloorRule())).apply((Applicative)instance, SurfaceMaterialProvider::create));

    public static SurfaceMaterialProvider create(final BlockState top, final BlockState under, final BlockState alt, final boolean genFloorRule) {
        return new SurfaceMaterialProvider(){

            @Override
            public BlockState getTopMaterial() {
                return top;
            }

            @Override
            public BlockState getUnderMaterial() {
                return under;
            }

            @Override
            public BlockState getAltTopMaterial() {
                return alt;
            }

            @Override
            public boolean generateFloorRule() {
                return genFloorRule;
            }

            @Override
            public SurfaceRuleBuilder surface() {
                return null;
            }
        };
    }

    public BlockState getTopMaterial();

    public BlockState getUnderMaterial();

    public BlockState getAltTopMaterial();

    public boolean generateFloorRule();

    public SurfaceRuleBuilder surface();
}

