/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.jetbrains.annotations.Nullable;

public interface BlockModelProvider
extends ItemModelProvider {
    @Environment(value=EnvType.CLIENT)
    @Nullable
    default public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        Optional<String> pattern = PatternsHelper.createBlockSimple(resourceLocation);
        return ModelsHelper.fromPattern(pattern);
    }

    @Environment(value=EnvType.CLIENT)
    default public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_());
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createBlockSimple(modelId);
    }

    @Environment(value=EnvType.CLIENT)
    default public void registerBlockModel(ResourceLocation stateId, ResourceLocation modelId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        if (!modelCache.containsKey(modelId)) {
            BlockModel model = this.getBlockModel(stateId, blockState);
            if (model != null) {
                model.f_111416_ = modelId.toString();
                modelCache.put(modelId, (UnbakedModel)model);
            } else {
                BCLib.LOGGER.warning("Error loading model: {}", modelId);
            }
        }
    }
}

