/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.commands.arguments.ConnectorArgument;
import org.betterx.bclib.commands.arguments.Float3ArgumentType;
import org.betterx.bclib.commands.arguments.PlacementDirections;
import org.betterx.bclib.commands.arguments.TemplatePlacementArgument;

class PlaceCommandBuilder {
    public static final String PATH = "path";
    public static final String NBT = "nbt";
    public static final String EMPTY = "empty";
    public static final String PLACEMENT = "placement";
    public static final String POS = "pos";
    public static final String RECURSION_DEPTH = "recursion_depth";
    public static final String SPAN = "span";
    public static final String BORDER = "border";
    public static final String ADD_CONTROLL_BLOCKS = "controller";
    public static final String FILL_VOID = "replaceair";
    public static final String JIGSAW = "jigsaw";
    public static final String CONNECTOR_NAME = "connector_name";
    public static final String REPLACE_WITH = "replace_with";
    public static final String ROLLABLE = "rollable";
    public static final String REPLACE_FROM_WORLD = "fromWorld";

    PlaceCommandBuilder() {
    }

    public void register(CommandBuildContext ctx, LiteralArgumentBuilder<CommandSourceStack> command) {
        Supplier<RequiredArgumentBuilder> path = () -> Commands.m_82129_((String)PATH, (ArgumentType)ResourceLocationArgument.m_106984_());
        Supplier<RequiredArgumentBuilder> placement = () -> Commands.m_82129_((String)PLACEMENT, (ArgumentType)TemplatePlacementArgument.templatePlacement());
        Supplier<RequiredArgumentBuilder> pos = () -> Commands.m_82129_((String)POS, (ArgumentType)BlockPosArgument.m_118239_());
        Supplier<RequiredArgumentBuilder> recursionDepth = () -> Commands.m_82129_((String)RECURSION_DEPTH, (ArgumentType)IntegerArgumentType.integer((int)0, (int)16));
        Function<Boolean, RequiredArgumentBuilder> placeIt = hasRecursionArg -> (RequiredArgumentBuilder)((RequiredArgumentBuilder)placement.get()).then(this.addOptionalsAndExecute(ctx, (RequiredArgumentBuilder)((RequiredArgumentBuilder)pos.get()), (boolean)hasRecursionArg, PlaceCommandBuilder::placeNBT));
        LiteralArgumentBuilder nbtTree = (LiteralArgumentBuilder)Commands.m_82127_((String)NBT).then(((RequiredArgumentBuilder)path.get().then(recursionDepth.get().then((ArgumentBuilder)placeIt.apply(true)))).then((ArgumentBuilder)placeIt.apply(false)));
        LiteralArgumentBuilder emptyTree = (LiteralArgumentBuilder)Commands.m_82127_((String)EMPTY).then(path.get().then(placement.get().then(pos.get().then(this.addOptionalsAndExecute(ctx, Commands.m_82129_((String)SPAN, (ArgumentType)Float3ArgumentType.int3(0, 64)), false, PlaceCommandBuilder::placeEmpty)))));
        Supplier<RequiredArgumentBuilder> replace = () -> Commands.m_82129_((String)REPLACE_WITH, (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)ctx));
        Supplier<LiteralArgumentBuilder> replace_source = () -> Commands.m_82127_((String)REPLACE_FROM_WORLD);
        Supplier<LiteralArgumentBuilder> rotate = () -> Commands.m_82127_((String)ROLLABLE);
        LiteralArgumentBuilder jigsawTree = (LiteralArgumentBuilder)Commands.m_82127_((String)JIGSAW).then(Commands.m_82129_((String)"pool", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registries.f_256948_)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)CONNECTOR_NAME, (ArgumentType)ConnectorArgument.id()).then(((RequiredArgumentBuilder)replace.get().then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, true, true, false))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, true, false, false))))).then(((LiteralArgumentBuilder)replace_source.get().then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, true, true))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, false, true))))).then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, true, false))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<CommandSourceStack>)cc, false, false, false)))));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then((ArgumentBuilder)nbtTree)).then((ArgumentBuilder)emptyTree)).then((ArgumentBuilder)jigsawTree);
    }

    private <T> RequiredArgumentBuilder<CommandSourceStack, T> addOptionalsAndExecute(CommandBuildContext commandBuildContext, RequiredArgumentBuilder<CommandSourceStack, T> root, boolean hasRecursionArgs, Executor runner) {
        Supplier<LiteralArgumentBuilder> addControllers = () -> Commands.m_82127_((String)ADD_CONTROLL_BLOCKS);
        Supplier<LiteralArgumentBuilder> replaceAir = () -> Commands.m_82127_((String)FILL_VOID);
        Supplier<RequiredArgumentBuilder> addBorder = () -> Commands.m_82129_((String)BORDER, (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext));
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)root.executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, false, false, false, hasRecursionArgs))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)addBorder.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, true, false, false, hasRecursionArgs))).then(addControllers.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, true, true, false, hasRecursionArgs)))).then(addControllers.get().then(replaceAir.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, true, true, true, hasRecursionArgs)))))).then(addControllers.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, false, true, false, hasRecursionArgs)))).then(addControllers.get().then(replaceAir.get().executes(c -> runner.exec((CommandContext<CommandSourceStack>)c, false, true, true, hasRecursionArgs))));
    }

    protected static int placeNBT(CommandContext<CommandSourceStack> ctx, boolean hasBorderArg, boolean controlBlocks, boolean replaceAir, boolean hasRecursionArg) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)PATH);
        PlacementDirections searchDir = TemplatePlacementArgument.getPlacement(ctx, PLACEMENT);
        BlockInput blockInput = hasBorderArg ? BlockStateArgument.m_116123_(ctx, (String)BORDER) : null;
        BlockPos pos = BlockPosArgument.m_118242_(ctx, (String)POS);
        int recursionDepth = hasRecursionArg ? IntegerArgumentType.getInteger(ctx, (String)RECURSION_DEPTH) : 1;
        List<StructureNBT> structures = StructureNBT.createResourcesFrom(id, recursionDepth);
        if (structures != null) {
            Bounds b = Bounds.of((BlockPos)pos);
            Bounds all = Bounds.of((BlockPos)pos);
            BlockPos pNew = pos;
            BlockPos rowStart = pos;
            String lastPrefix = null;
            for (StructureNBT s : structures) {
                String prefix;
                String string = prefix = s.location.m_135815_().contains("/") ? s.location.m_135815_().replaceAll("/[^/]*$", "") : "";
                if (lastPrefix != null && !lastPrefix.equals(prefix)) {
                    rowStart = pNew = searchDir.resetStart(b, pNew, 10);
                    b = Bounds.of((BlockPos)pNew);
                }
                lastPrefix = prefix;
                Bounds bb = Bounds.of((BoundingBox)Objects.requireNonNull(PlaceCommand.placeBlocks((CommandSourceStack)ctx.getSource(), rowStart, searchDir.getOffset(), blockInput, controlBlocks, replaceAir, true, s.location, p -> s.getBoundingBox((BlockPos)p, Rotation.NONE, Mirror.NONE), (level, p) -> s.generateAt((ServerLevelAccessor)level, (BlockPos)p, Rotation.NONE, Mirror.NONE))));
                rowStart = searchDir.advanceStart(bb, rowStart);
                b = b.encapsulate(bb);
                all = all.encapsulate(bb);
                if (searchDir.sizeInDirection(b) <= 160) continue;
                rowStart = pNew = searchDir.resetStart(b, pNew);
                b = Bounds.of((BlockPos)pNew);
            }
            Bounds finalAll = all;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Placed " + structures.size() + " NBTs: " + finalAll.toString())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), true);
            return 0;
        }
        StructureNBT structureNBT = StructureNBT.create(id);
        return PlaceCommand.placeBlocks((CommandSourceStack)ctx.getSource(), pos, searchDir.getOffset(), blockInput, controlBlocks, replaceAir, true, structureNBT.location, p -> structureNBT.getBoundingBox((BlockPos)p, Rotation.NONE, Mirror.NONE), (level, p) -> structureNBT.generateAt((ServerLevelAccessor)level, (BlockPos)p, Rotation.NONE, Mirror.NONE)) == null ? 1 : -1;
    }

    protected static int placeEmpty(CommandContext<CommandSourceStack> ctx, boolean hasBorderArg, boolean controlBlocks, boolean replaceAir, boolean hasRecursionArg) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)PATH);
        PlacementDirections searchDir = TemplatePlacementArgument.getPlacement(ctx, PLACEMENT);
        BlockInput blockInput = hasBorderArg ? BlockStateArgument.m_116123_(ctx, (String)BORDER) : null;
        BlockPos span = Float3ArgumentType.getFloat3(ctx, SPAN).toBlockPos();
        return PlaceCommand.placeBlocks((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_(ctx, (String)POS), searchDir == null || searchDir.dir == Float3.ZERO ? null : searchDir.dir.toBlockPos(), blockInput, controlBlocks, replaceAir, false, id, p -> BoundingBox.m_162375_((Vec3i)p, (Vec3i)p.m_121955_((Vec3i)span)), (level, p) -> {
            BoundingBox box = BoundingBox.m_162375_((Vec3i)p, (Vec3i)p.m_121955_((Vec3i)span));
            PlaceCommand.fillStructureVoid((Level)level, box);
            if (blockInput != null) {
                PlaceCommand.fill((Level)level, new BoundingBox(box.m_162395_(), box.m_162396_() - 1, box.m_162398_(), box.m_162399_(), box.m_162396_() - 1, box.m_162401_()), blockInput.m_114669_());
            }
        }) == null ? 1 : -1;
    }

    public static int placeJigsaw(CommandContext<CommandSourceStack> ctx, boolean hasReplaceArg, boolean rotate, boolean replaceFromWorld) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(ctx, (String)POS);
        Holder.Reference pool = ResourceKeyArgument.m_247435_(ctx, (String)"pool");
        ResourceLocation connector = ResourceLocationArgument.m_107011_(ctx, (String)CONNECTOR_NAME);
        if (connector.m_135827_().equals("-")) {
            connector = new ResourceLocation(pool.m_205785_().m_135782_().m_135827_(), connector.m_135815_());
        }
        BlockState replaceWith = hasReplaceArg ? BlockStateArgument.m_116123_(ctx, (String)REPLACE_WITH).m_114669_() : Blocks.f_50016_.m_49966_();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        int deltaY = player.m_146904_() - pos.m_123342_();
        BlockState state = Blocks.f_50678_.m_49966_();
        state = deltaY < 2 && deltaY > -2 && !rotate ? (BlockState)state.m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)player.m_6350_().m_122424_(), (Direction)Direction.UP)) : (deltaY < 0 ? (BlockState)state.m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.DOWN, (Direction)player.m_6350_().m_122424_())) : (BlockState)state.m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.UP, (Direction)player.m_6350_().m_122424_())));
        if (replaceFromWorld) {
            replaceWith = level.m_8055_(pos);
        }
        level.m_7731_(pos, state, 18);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof JigsawBlockEntity) {
            JigsawBlockEntity entity = (JigsawBlockEntity)blockEntity;
            entity.m_59435_(connector);
            entity.m_59438_(connector);
            entity.m_222763_(pool.m_205785_());
            entity.m_59431_(BlockStateParser.m_116769_((BlockState)replaceWith));
            if (rotate) {
                entity.m_59424_(JigsawBlockEntity.JointType.ROLLABLE);
            } else {
                entity.m_59424_(JigsawBlockEntity.JointType.ALIGNED);
            }
        }
        return 1;
    }

    public static int placeSpawner(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(ctx, (String)POS);
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        level.m_7731_(pos, Blocks.f_50085_.m_49966_(), 18);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity entity = (SpawnerBlockEntity)blockEntity;
            CompoundTag tag = TagParser.m_129359_((String)"{SpawnData:{entity:{id:wither_skeleton,PersistenceRequired:1,HandItems:[{Count:1,id:netherite_sword},{Count:1,id:shield}],ArmorItems:[{Count:1,id:netherite_boots,tag:{Enchantments:[{id:protection,lvl:1}]}},{Count:1,id:netherite_leggings,tag:{Enchantments:[{id:protection,lvl:1}]}},{Count:1,id:netherite_chestplate,tag:{Enchantments:[{id:protection,lvl:1},{id:thorns,lvl:3}]}},{Count:1,id:netherite_helmet,tag:{Enchantments:[{id:protection,lvl:1}]}}],HandDropChances:[0.0f,0.0f],ArmorDropChances:[0.0f,0.0f,0.0f,0.0f]}, custom_spawn_rules:{sky_light_limit:{max_inclusive:13},block_light_limit:{max_inclusive:11}}},SpawnRange:4,SpawnCount:8,MaxNearbyEntities:18,Delay:499,MinSpawnDelay:300,MaxSpawnDelay:1600,RequiredPlayerRange:20}");
            entity.m_142466_(tag);
        }
        return 1;
    }

    static interface Executor {
        public int exec(CommandContext<CommandSourceStack> var1, boolean var2, boolean var3, boolean var4, boolean var5) throws CommandSyntaxException;
    }
}

