/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks.signs;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourExplosionResistant;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.signs.BaseWallSignBlock;
import org.betterx.bclib.complexmaterials.BCLWoodTypeWrapper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BaseSignBlock
extends StandingSignBlock
implements BlockModelProvider,
CustomItemProvider,
TagProvider,
DropSelfLootProvider<BaseSignBlock>,
BehaviourExplosionResistant {
    protected final Supplier<BaseWallSignBlock> wallSign = () -> provider.create(BehaviourBuilders.createWallSign(color, (Block)this, flammable), type);
    private BlockItem customItem;
    private BaseWallSignBlock wallSignBlock;

    protected BaseSignBlock(WoodType type, MapColor color, boolean flammable, WallSignProvider provider) {
        super(BehaviourBuilders.createSign(color, flammable), type);
    }

    public BaseWallSignBlock getWallSignBlock() {
        if (this.wallSignBlock == null) {
            this.wallSignBlock = this.wallSign.get();
        }
        return this.wallSignBlock;
    }

    public float m_276903_(BlockState blockState) {
        return RotationSegment.m_245107_((int)((Integer)blockState.m_61143_((Property)StandingSignBlock.f_56987_)));
    }

    @Override
    public BlockItem getCustomItem(ResourceLocation blockID, Item.Properties settings) {
        if (this.customItem == null) {
            this.customItem = new SignItem(settings, (Block)this, (Block)this.getWallSignBlock());
        }
        return this.customItem;
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13066_);
        itemTags.add((TagKey<Item>)ItemTags.f_13157_);
    }

    public static BaseSignBlock from(BCLWoodTypeWrapper type) {
        return new Wood(type);
    }

    @FunctionalInterface
    public static interface WallSignProvider {
        public BaseWallSignBlock create(BlockBehaviour.Properties var1, WoodType var2);
    }

    public static class Wood
    extends BaseSignBlock
    implements BehaviourWood {
        public Wood(WoodType type) {
            this(type, MapColor.f_283825_, true);
        }

        public Wood(BCLWoodTypeWrapper type) {
            this(type.type, type.color, type.flammable);
        }

        public Wood(WoodType type, MapColor color, boolean flammable) {
            super(type, color, flammable, BaseWallSignBlock.Wood::new);
        }
    }
}

