/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.blocks.BaseTerrainBlock;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.jetbrains.annotations.Nullable;

public class TripleTerrainBlock
extends BaseTerrainBlock {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public TripleTerrainBlock(Block baseBlock) {
        super(baseBlock, baseBlock.m_284356_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
    }

    public TripleTerrainBlock(Block baseBlock, MapColor color) {
        super(baseBlock, color);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction dir = ctx.m_43719_();
        BlockProperties.TripleShape shape = dir == Direction.UP ? BlockProperties.TripleShape.BOTTOM : (dir == Direction.DOWN ? BlockProperties.TripleShape.TOP : BlockProperties.TripleShape.MIDDLE);
        return (BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)shape));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)((Object)state.m_61143_(SHAPE));
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)((Object)state.m_61143_(SHAPE));
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            super.m_213898_(state, world, pos, random);
        } else if (random.m_188503_(16) == 0) {
            boolean bottom = this.canStayBottom((LevelReader)world, pos);
            if (shape == BlockProperties.TripleShape.TOP) {
                if (!bottom) {
                    world.m_46597_(pos, Blocks.f_50259_.m_49966_());
                }
            } else {
                boolean top;
                boolean bl = top = this.canStay(state, (LevelReader)world, pos) || this.isMiddle(world.m_8055_(pos.m_7494_()));
                if (!top && !bottom) {
                    world.m_46597_(pos, Blocks.f_50259_.m_49966_());
                } else if (top && !bottom) {
                    world.m_46597_(pos, (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
                } else if (!top) {
                    world.m_46597_(pos, (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
                }
            }
        }
    }

    protected boolean canStayBottom(LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (this.isMiddle(blockState)) {
            return true;
        }
        if (blockState.m_60819_().m_76186_() == 8) {
            return false;
        }
        return !blockState.m_60783_((BlockGetter)world, blockPos, Direction.UP);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        return this.getBlockModel(blockId, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        Optional<String> pattern;
        String path = blockId.m_135815_();
        if (this.isMiddle(blockState)) {
            ResourceLocation topId = new ResourceLocation(blockId.m_135827_(), path + "_top");
            pattern = PatternsHelper.createBlockSimple(topId);
        } else {
            HashMap textures = Maps.newHashMap();
            textures.put("%top%", "betterend:block/" + path + "_top");
            textures.put("%side%", "betterend:block/" + path + "_side");
            textures.put("%bottom%", "minecraft:block/end_stone");
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_TOP_SIDE_BOTTOM, textures);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        boolean isMiddle = this.isMiddle(blockState);
        String middle = isMiddle ? "_middle" : "";
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + middle);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        if (isMiddle) {
            ArrayList variants = Lists.newArrayList();
            for (BlockModelRotation rotation : BlockModelRotation.values()) {
                variants.add(new Variant(modelId, rotation.m_6189_(), false, 1));
            }
            return new MultiVariant((List)variants);
        }
        if (blockState.m_61143_(SHAPE) == BlockProperties.TripleShape.TOP) {
            return new MultiVariant((List)Lists.newArrayList((Object[])new Variant[]{new Variant(modelId, BlockModelRotation.X180_Y0.m_6189_(), false, 1), new Variant(modelId, BlockModelRotation.X180_Y90.m_6189_(), false, 1), new Variant(modelId, BlockModelRotation.X180_Y180.m_6189_(), false, 1), new Variant(modelId, BlockModelRotation.X180_Y270.m_6189_(), false, 1)}));
        }
        return ModelsHelper.createRandomTopModel(modelId);
    }

    protected boolean isMiddle(BlockState blockState) {
        return blockState.m_60713_((Block)this) && blockState.m_61143_(SHAPE) == BlockProperties.TripleShape.MIDDLE;
    }
}

