/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BasePlantBlock;
import org.betterx.bclib.util.BlocksHelper;

public abstract class BaseWallPlantBlock
extends BasePlantBlock {
    private static final EnumMap<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)BaseWallPlantBlock.m_49796_((double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)BaseWallPlantBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)8.0), (Object)Direction.WEST, (Object)BaseWallPlantBlock.m_49796_((double)8.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (Object)Direction.EAST, (Object)BaseWallPlantBlock.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0)));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    protected BaseWallPlantBlock(BlockBehaviour.Properties settings) {
        super(settings.m_222979_(BlockBehaviour.OffsetType.NONE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return this.isSupport(level, blockPos, blockState, direction);
    }

    public boolean isSupport(LevelReader world, BlockPos pos, BlockState blockState, Direction direction) {
        return blockState.m_280296_() && blockState.m_60783_((BlockGetter)world, pos, direction);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : directions = ctx.m_6232_()) {
            Direction direction2;
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }
}

