/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRotatedPillarBlock
extends RotatedPillarBlock
implements BlockModelProvider,
DropSelfLootProvider<BaseRotatedPillarBlock> {
    protected BaseRotatedPillarBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected BaseRotatedPillarBlock(Block block) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        return this.getBlockModel(blockId, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        Optional<String> pattern = this.createBlockPattern(blockId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_());
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createRotatedModel(modelId, (Direction.Axis)blockState.m_61143_((Property)f_55923_));
    }

    protected Optional<String> createBlockPattern(ResourceLocation blockId) {
        return PatternsHelper.createBlockPillar(blockId);
    }

    public static BaseRotatedPillarBlock from(Block source, boolean flammable) {
        return BehaviourHelper.from(source, s -> new Wood((Block)s, flammable), Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseRotatedPillarBlock
    implements BehaviourWood {
        protected final boolean flammable;

        public Wood(BlockBehaviour.Properties settings, boolean flammable) {
            super(flammable ? settings.m_278183_() : settings);
            this.flammable = flammable;
        }

        public Wood(Block block, boolean flammable) {
            this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block), flammable);
        }
    }

    public static class Metal
    extends BaseRotatedPillarBlock
    implements BehaviourMetal {
        public Metal(BlockBehaviour.Properties settings) {
            super(settings);
        }

        public Metal(Block block) {
            super(block);
        }
    }

    public static class Stone
    extends BaseRotatedPillarBlock
    implements BehaviourStone {
        public Stone(BlockBehaviour.Properties settings) {
            super(settings);
        }

        public Stone(Block block) {
            super(block);
        }
    }
}

