/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BasePressurePlateBlock
extends PressurePlateBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BasePressurePlateBlock> {
    private final Block parent;

    protected BasePressurePlateBlock(PressurePlateBlock.Sensitivity rule, Block source, BlockSetType type) {
        super(rule, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60910_().m_60955_().m_60978_(0.5f), type);
        this.parent = source;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        ResourceLocation parentId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        Optional<String> pattern = (Boolean)blockState.m_61143_((Property)f_55249_) != false ? PatternsHelper.createJson(BasePatterns.BLOCK_PLATE_DOWN, parentId) : PatternsHelper.createJson(BasePatterns.BLOCK_PLATE_UP, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        String state = (Boolean)blockState.m_61143_((Property)f_55249_) != false ? "_down" : "_up";
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + state);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createBlockSimple(modelId);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13099_);
    }

    public static BasePressurePlateBlock from(Block source, BlockSetType type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BasePressurePlateBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            super(PressurePlateBlock.Sensitivity.MOBS, source, type);
        }
    }

    public static class Stone
    extends BasePressurePlateBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            super(PressurePlateBlock.Sensitivity.MOBS, source, type);
        }
    }

    public static class Wood
    extends BasePressurePlateBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type) {
            super(PressurePlateBlock.Sensitivity.EVERYTHING, source, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13100_);
            itemTags.add((TagKey<Item>)ItemTags.f_13177_);
        }
    }
}

