/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBarsBlock
extends IronBarsBlock
implements BlockModelProvider,
RenderLayerProvider,
BehaviourMetal {
    public BaseBarsBlock(Block source) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60913_(5.0f, 6.0f).m_60955_());
    }

    public BaseBarsBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    public Optional<String> getModelString(String block) {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)this);
        if (block.contains("item")) {
            return PatternsHelper.createJson(BasePatterns.ITEM_BLOCK, blockId);
        }
        if (block.contains("post")) {
            return PatternsHelper.createJson(BasePatterns.BLOCK_BARS_POST, blockId);
        }
        return PatternsHelper.createJson(BasePatterns.BLOCK_BARS_SIDE, blockId);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return ModelsHelper.createBlockItem(resourceLocation);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        ResourceLocation thisId = BuiltInRegistries.f_256975_.m_7981_((Object)this);
        String path = blockId.m_135815_();
        Optional<String> pattern = Optional.empty();
        if (path.endsWith("_post")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_BARS_POST, thisId);
        }
        if (path.endsWith("_side")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_BARS_SIDE, thisId);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        ResourceLocation postId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + "_post");
        ResourceLocation sideId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + "_side");
        this.registerBlockModel(postId, postId, blockState, modelCache);
        this.registerBlockModel(sideId, sideId, blockState, modelCache);
        ModelsHelper.MultiPartBuilder builder = ModelsHelper.MultiPartBuilder.create((StateDefinition<Block, BlockState>)this.f_49792_);
        builder.part(postId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52309_) == false && (Boolean)state.m_61143_((Property)f_52310_) == false && (Boolean)state.m_61143_((Property)f_52311_) == false && (Boolean)state.m_61143_((Property)f_52312_) == false).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52309_)).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52310_)).setTransformation(BlockModelRotation.X0_Y90.m_6189_()).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52311_)).setTransformation(BlockModelRotation.X0_Y180.m_6189_()).setUVLock(true).add();
        builder.part(sideId).setCondition(state -> (Boolean)state.m_61143_((Property)f_52312_)).setTransformation(BlockModelRotation.X0_Y270.m_6189_()).setUVLock(true).add();
        return builder.build();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        if (direction.m_122434_().m_122478_() && stateFrom.m_60734_() == this && !stateFrom.equals(state)) {
            return false;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public static class Metal
    extends BaseBarsBlock
    implements BehaviourMetal {
        public Metal(Block source) {
            super(source);
        }

        public Metal(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

