/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blockentities;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DynamicBlockEntityType<T extends BlockEntity>
extends BlockEntityType<T> {
    private final Set<Block> validBlocks = Sets.newHashSet();
    private final BlockEntitySupplier<? extends T> factory;

    public DynamicBlockEntityType(BlockEntitySupplier<? extends T> supplier) {
        super(null, Collections.emptySet(), null);
        this.factory = supplier;
    }

    @Nullable
    public T m_155264_(BlockPos blockPos, BlockState blockState) {
        return this.factory.create(blockPos, blockState);
    }

    public boolean m_155262_(BlockState blockState) {
        return this.validBlocks.contains(blockState.m_60734_());
    }

    public void registerBlock(Block block) {
        this.validBlocks.add(block);
    }

    @FunctionalInterface
    public static interface BlockEntitySupplier<T extends BlockEntity> {
        public T create(BlockPos var1, BlockState var2);
    }
}

