/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.bclib.api.v3.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.util.BlocksHelper;

public class UnderEveryLayer
extends PlacementModifier {
    private static final UnderEveryLayer INSTANCE = new UnderEveryLayer(Optional.empty(), Optional.empty());
    private static final UnderEveryLayer INSTANCE_MIN_4 = new UnderEveryLayer(Optional.of(4), Optional.empty());
    public static final Codec<UnderEveryLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min").forGetter(o -> o.minHeight), (App)Codec.INT.optionalFieldOf("max").forGetter(o -> o.maxHeight)).apply((Applicative)instance, UnderEveryLayer::new));
    private final Optional<Integer> minHeight;
    private final Optional<Integer> maxHeight;

    protected UnderEveryLayer(Optional<Integer> minHeight, Optional<Integer> maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public static UnderEveryLayer simple() {
        return INSTANCE;
    }

    public static UnderEveryLayer min4() {
        return INSTANCE_MIN_4;
    }

    public Stream<BlockPos> m_213676_(PlacementContext ctx, RandomSource random, BlockPos pos) {
        int layerY;
        Stream.Builder<BlockPos> builder = Stream.builder();
        int z = pos.m_123343_();
        int x = pos.m_123341_();
        int levelHeight = ctx.m_191824_(Heightmap.Types.MOTION_BLOCKING, x, z);
        int minLevelHeight = ctx.m_191830_();
        int y = this.maxHeight.map(h -> Math.min(levelHeight, h)).orElse(levelHeight);
        int minHeight = this.minHeight.map(h -> Math.max(minLevelHeight, h)).orElse(minLevelHeight);
        do {
            if ((layerY = UnderEveryLayer.findUnderGroundYPosition(ctx, x, y, z, minHeight)) == Integer.MAX_VALUE) continue;
            builder.add(new BlockPos(x, layerY, z));
            y = layerY - 1;
        } while (layerY != Integer.MAX_VALUE);
        return builder.build();
    }

    public PlacementModifierType<UnderEveryLayer> m_183327_() {
        return PlacementModifiers.UNDER_EVERY_LAYER;
    }

    private static int findUnderGroundYPosition(PlacementContext ctx, int x, int startY, int z, int minHeight) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, startY, z);
        BlockState nowState = ctx.m_191828_((BlockPos)mPos);
        for (int y = startY; y >= minHeight + 1; --y) {
            mPos.m_142448_(y - 1);
            BlockState belowState = ctx.m_191828_((BlockPos)mPos);
            if (BlocksHelper.isTerrain(nowState) && BlocksHelper.isFreeOrFluid(belowState) && !nowState.m_60713_(Blocks.f_50752_)) {
                return mPos.m_123342_();
            }
            nowState = belowState;
        }
        return Integer.MAX_VALUE;
    }
}

