/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.poi;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import org.betterx.bclib.api.v2.poi.PoiManager;

public class BCLPoiType {
    public final ResourceKey<PoiType> key;
    public final PoiType type;
    public final Set<BlockState> matchingStates;
    public final int maxTickets;
    public final int validRange;

    public BCLPoiType(ResourceKey<PoiType> key, PoiType type, Set<BlockState> matchingStates, int maxTickets, int validRange) {
        this.key = key;
        this.type = type;
        this.matchingStates = matchingStates;
        this.maxTickets = maxTickets;
        this.validRange = validRange;
    }

    public static Set<BlockState> getBlockStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_());
    }

    public void setTag(TagKey<Block> tag) {
        PoiManager.setTag(this.key, tag);
    }

    public Optional<BlockPos> findPoiAround(ServerLevel level, BlockPos center, boolean wideSearch, WorldBorder worldBorder) {
        return BCLPoiType.findPoiAround(this.key, level, center, wideSearch, worldBorder);
    }

    public Optional<BlockPos> findClosest(ServerLevel level, BlockPos center, int radius) {
        return level.m_8904_().m_148658_(holder -> holder.m_203565_(this.key), pos -> true, center, radius, PoiManager.Occupancy.ANY);
    }

    public Optional<BlockPos> findPoiAround(ServerLevel level, BlockPos center, int radius, WorldBorder worldBorder) {
        return BCLPoiType.findPoiAround(this.key, level, center, radius, worldBorder);
    }

    public static Optional<BlockPos> findPoiAround(ResourceKey<PoiType> key, ServerLevel level, BlockPos center, boolean wideSearch, WorldBorder worldBorder) {
        return BCLPoiType.findPoiAround(key, level, center, wideSearch ? 16 : 128, worldBorder);
    }

    public static Optional<BlockPos> findPoiAround(ResourceKey<PoiType> key, ServerLevel level, BlockPos center, int radius, WorldBorder worldBorder) {
        net.minecraft.world.entity.ai.village.poi.PoiManager poiManager = level.m_8904_();
        poiManager.m_27056_((LevelReader)level, center, radius);
        Optional<PoiRecord> record = poiManager.m_27166_(holder -> holder.m_203565_(key), center, radius, PoiManager.Occupancy.ANY).filter(poiRecord -> worldBorder.m_61937_(poiRecord.m_27257_())).sorted(Comparator.comparingDouble(poiRecord -> poiRecord.m_27257_().m_123331_((Vec3i)center)).thenComparingInt(poiRecord -> poiRecord.m_27257_().m_123342_())).filter(poiRecord -> level.m_8055_(poiRecord.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return record.map(poiRecord -> poiRecord.m_27257_());
    }
}

