/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.surface.rules;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.ThreadSafeLegacyRandomSource;
import org.betterx.bclib.api.v2.levelgen.surface.rules.SurfaceNoiseCondition;
import org.betterx.bclib.mixin.common.SurfaceRulesContextAccessor;
import org.betterx.bclib.noise.OpenSimplexNoise;

public class ThresholdCondition
extends SurfaceNoiseCondition {
    private static final Map<Long, Context> NOISES = Maps.newHashMap();
    public static final Codec<ThresholdCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(p -> p.noiseContext.seed), (App)Codec.DOUBLE.fieldOf("threshold").orElse((Object)0.0).forGetter(p -> p.threshold), (App)FloatProvider.f_146502_.fieldOf("threshold_offset").orElse((Object)ConstantFloat.m_146458_((float)0.0f)).forGetter(p -> p.range), (App)Codec.DOUBLE.fieldOf("scale_x").orElse((Object)0.1).forGetter(p -> p.scaleX), (App)Codec.DOUBLE.fieldOf("scale_z").orElse((Object)0.1).forGetter(p -> p.scaleZ)).apply((Applicative)instance, ThresholdCondition::new));
    public static final KeyDispatchDataCodec<ThresholdCondition> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);
    private final Context noiseContext;
    private final double threshold;
    private final FloatProvider range;
    private final double scaleX;
    private final double scaleZ;

    public ThresholdCondition(long noiseSeed, double threshold, FloatProvider range, double scaleX, double scaleZ) {
        this.threshold = threshold;
        this.range = range;
        this.scaleX = scaleX;
        this.scaleZ = scaleZ;
        this.noiseContext = NOISES.computeIfAbsent(noiseSeed, seed -> new Context((long)seed));
    }

    @Override
    public boolean test(SurfaceRulesContextAccessor context) {
        double x = (double)context.getBlockX() * this.scaleX;
        double z = (double)context.getBlockZ() * this.scaleZ;
        if (this.noiseContext.lastX == x && this.noiseContext.lastZ == z) {
            return this.noiseContext.lastValue + (double)this.range.m_214084_(this.noiseContext.random) > this.threshold;
        }
        double value = this.noiseContext.noise.eval(x, z);
        this.noiseContext.lastX = x;
        this.noiseContext.lastZ = z;
        this.noiseContext.lastValue = value;
        return value + (double)this.range.m_214084_(this.noiseContext.random) > this.threshold;
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
        return KEY_CODEC;
    }

    static class Context {
        public final OpenSimplexNoise noise;
        public final RandomSource random;
        public final long seed;
        public double lastX = -2.147483648E9;
        public double lastZ = -2.147483648E9;
        public double lastValue = 0.0;

        Context(long seed) {
            this.seed = seed;
            this.noise = new OpenSimplexNoise(seed);
            this.random = new ThreadSafeLegacyRandomSource(seed * 2L);
        }
    }
}

