/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.surface.rules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.bclib.mixin.common.SurfaceRulesContextAccessor;
import org.betterx.bclib.noise.Noises;

public class RoughNoiseCondition
implements SurfaceRules.ConditionSource {
    public static final Codec<RoughNoiseCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256865_).fieldOf("noise").forGetter(o -> o.noise), (App)Codec.DOUBLE.fieldOf("min_threshold").forGetter(o -> o.minThreshold), (App)Codec.DOUBLE.fieldOf("max_threshold").forGetter(o -> o.maxThreshold), (App)FloatProvider.f_146502_.fieldOf("roughness").forGetter(o -> o.roughness)).apply((Applicative)instance, (noise1, minThreshold1, maxThreshold1, roughness1) -> new RoughNoiseCondition((ResourceKey<NormalNoise.NoiseParameters>)noise1, (FloatProvider)roughness1, (double)minThreshold1, (double)maxThreshold1)));
    public static final KeyDispatchDataCodec<RoughNoiseCondition> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);
    private final ResourceKey<NormalNoise.NoiseParameters> noise;
    private final double minThreshold;
    private final double maxThreshold;
    private final FloatProvider roughness;

    public RoughNoiseCondition(ResourceKey<NormalNoise.NoiseParameters> noise, FloatProvider roughness, double minThreshold, double maxThreshold) {
        this.noise = noise;
        this.minThreshold = minThreshold;
        this.maxThreshold = maxThreshold;
        this.roughness = roughness;
    }

    public RoughNoiseCondition(ResourceKey<NormalNoise.NoiseParameters> noise, FloatProvider roughness, double minThreshold) {
        this(noise, roughness, minThreshold, Double.MAX_VALUE);
    }

    public RoughNoiseCondition(ResourceKey<NormalNoise.NoiseParameters> noise, double minThreshold) {
        this(noise, (FloatProvider)UniformFloat.m_146605_((float)-0.2f, (float)0.4f), minThreshold, Double.MAX_VALUE);
    }

    public RoughNoiseCondition(ResourceKey<NormalNoise.NoiseParameters> noise, double minThreshold, double maxThreshold) {
        this(noise, (FloatProvider)UniformFloat.m_146605_((float)-0.1f, (float)0.4f), minThreshold, maxThreshold);
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
        return KEY_CODEC;
    }

    public SurfaceRules.Condition apply(final SurfaceRules.Context context2) {
        final SurfaceRulesContextAccessor ctx = (SurfaceRulesContextAccessor)SurfaceRulesContextAccessor.class.cast(context2);
        final NormalNoise normalNoise = ctx.getRandomState().m_224560_(this.noise);
        final RandomSource roughnessSource = ctx.getRandomState().m_224565_(Noises.ROUGHNESS_NOISE.m_135782_()).m_224540_(Noises.ROUGHNESS_NOISE.m_135782_());
        class NoiseThresholdCondition
        extends SurfaceRules.LazyCondition {
            NoiseThresholdCondition() {
                super(context);
            }

            protected long m_183477_() {
                SurfaceRulesContextAccessor ctx2 = (SurfaceRulesContextAccessor)SurfaceRulesContextAccessor.class.cast(this.f_189616_);
                return ctx2.getLastUpdateY() + ctx2.getLastUpdateXZ();
            }

            protected boolean m_183479_() {
                double d = normalNoise.m_75380_((double)ctx.getBlockX(), (double)ctx.getBlockZ(), (double)ctx.getBlockZ()) + (double)RoughNoiseCondition.this.roughness.m_214084_(roughnessSource);
                return d >= RoughNoiseCondition.this.minThreshold && d <= RoughNoiseCondition.this.maxThreshold;
            }
        }
        return new NoiseThresholdCondition();
    }
}

