/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.TemplatePiece;

public abstract class TemplateStructure
extends Structure {
    protected final List<Config> configs;

    public static <T extends TemplateStructure> Codec<T> simpleTemplateCodec(BiFunction<Structure.StructureSettings, List<Config>, T> instancer) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Structure.m_226567_((RecordCodecBuilder.Instance)instance), (App)ExtraCodecs.m_144637_((Codec)Config.CODEC.listOf()).fieldOf("configs").forGetter(ruinedPortalStructure -> ruinedPortalStructure.configs)).apply((Applicative)instance, instancer));
    }

    protected TemplateStructure(Structure.StructureSettings structureSettings, ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
        this(structureSettings, List.of(new Config(location, offsetY, type, chance)));
    }

    protected TemplateStructure(Structure.StructureSettings structureSettings, List<Config> configs) {
        super(structureSettings);
        this.configs = configs;
    }

    protected Config randomConfig(RandomSource random) {
        if (this.configs.size() > 1) {
            float chanceSum = this.configs.parallelStream().map(c -> Float.valueOf(c.chance())).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue();
            float rnd = random.m_188501_() * chanceSum;
            for (Config c2 : this.configs) {
                if (!((rnd -= c2.chance()) <= 0.0f)) continue;
                return c2;
            }
        } else {
            return this.configs.get(0);
        }
        return null;
    }

    protected boolean isLavaPlaceable(BlockState state, BlockState before) {
        return (state == null || state.m_60713_(Blocks.f_50016_)) && before.m_60713_(Blocks.f_49991_);
    }

    protected boolean isFloorPlaceable(BlockState state, BlockState before) {
        return (state == null || state.m_60713_(Blocks.f_50016_)) && before.m_280296_();
    }

    protected int erosion(RandomSource rnd) {
        return 0;
    }

    protected boolean cover(RandomSource rnd) {
        return false;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext ctx) {
        int searchStep;
        int minBaseCount;
        BiPredicate<BlockState, BlockState> isCorrectBase;
        int z;
        Config config = this.randomConfig((RandomSource)ctx.f_226626_());
        if (config == null) {
            return Optional.empty();
        }
        ChunkPos chunkPos = ctx.f_226628_();
        int x = chunkPos.m_45604_();
        if (!this.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.m_45605_())) {
            return Optional.empty();
        }
        WorldGenerationContext worldGenerationContext = new WorldGenerationContext(ctx.f_226622_(), ctx.f_226629_());
        StructureTemplate structureTemplate = ctx.f_226625_().m_230359_(config.location);
        float minAirRatio = 0.6f;
        if (config.type == StructurePlacementType.LAVA) {
            isCorrectBase = this::isLavaPlaceable;
            minBaseCount = 5;
            searchStep = 1;
        } else if (config.type == StructurePlacementType.CEIL) {
            isCorrectBase = this::isFloorPlaceable;
            minBaseCount = 3;
            searchStep = -1;
        } else {
            isCorrectBase = this::isFloorPlaceable;
            minBaseCount = 3;
            searchStep = 1;
        }
        int seaLevel = ctx.f_226622_().m_6337_() + (searchStep > 0 ? 0 : structureTemplate.m_163808_(Rotation.NONE).m_123342_() + config.offsetY);
        int maxHeight = worldGenerationContext.m_142208_() - 4 - (searchStep > 0 ? structureTemplate.m_163808_(Rotation.NONE).m_123342_() + config.offsetY : 0);
        BlockPos halfSize = new BlockPos(structureTemplate.m_163801_().m_123341_() / 2, 0, structureTemplate.m_163801_().m_123343_() / 2);
        Rotation rotation = StructureNBT.getRandomRotation((RandomSource)ctx.f_226626_());
        Mirror mirror = StructureNBT.getRandomMirror((RandomSource)ctx.f_226626_());
        BlockPos.MutableBlockPos centerPos = new BlockPos.MutableBlockPos(x, 0, z);
        BoundingBox boundingBox = structureTemplate.m_74598_((BlockPos)centerPos, rotation, halfSize, mirror);
        List<NoiseColumn> noiseColumns = ImmutableList.of((Object)new BlockPos(boundingBox.m_162394_().m_123341_(), 0, boundingBox.m_162394_().m_123343_()), (Object)new BlockPos(boundingBox.m_162395_(), 0, boundingBox.m_162398_()), (Object)new BlockPos(boundingBox.m_162399_(), 0, boundingBox.m_162398_()), (Object)new BlockPos(boundingBox.m_162395_(), 0, boundingBox.m_162401_()), (Object)new BlockPos(boundingBox.m_162399_(), 0, boundingBox.m_162401_())).stream().map(blockPos -> ctx.f_226622_().m_214184_(blockPos.m_123341_(), blockPos.m_123343_(), ctx.f_226629_(), ctx.f_226624_())).toList();
        int y = noiseColumns.stream().map(column -> this.findY((NoiseColumn)column, isCorrectBase, searchStep, seaLevel, maxHeight)).reduce(searchStep > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE, (p, c) -> searchStep > 0 ? Math.min(p, c) : Math.max(p, c));
        if (y >= maxHeight || y < seaLevel) {
            return Optional.empty();
        }
        if (!BCLStructure.isValidBiome(ctx, y)) {
            return Optional.empty();
        }
        int baseCount = noiseColumns.stream().map(column -> isCorrectBase.test(null, column.m_183556_(y - searchStep))).filter(b -> b).map(b -> 1).reduce(0, (p, c) -> p + c);
        if (baseCount < minBaseCount) {
            return Optional.empty();
        }
        float airRatio = noiseColumns.stream().map(column -> Float.valueOf(this.airRatio((NoiseColumn)column, y, boundingBox.m_71057_(), searchStep))).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue() / (float)noiseColumns.size();
        if (airRatio < 0.6f) {
            return Optional.empty();
        }
        centerPos.m_142448_(y - (searchStep == 1 ? 0 : structureTemplate.m_163808_(Rotation.NONE).m_123342_()));
        int erosion = this.erosion((RandomSource)ctx.f_226626_());
        boolean cover = this.cover((RandomSource)ctx.f_226626_());
        return Optional.of(new Structure.GenerationStub((BlockPos)centerPos, structurePiecesBuilder -> structurePiecesBuilder.m_142679_((StructurePiece)new TemplatePiece(ctx.f_226625_(), config.location, centerPos.m_7918_(0, config.offsetY, 0), rotation, mirror, halfSize, erosion, cover))));
    }

    private boolean hasValidBiomeAtRandomHeight(Structure.GenerationContext ctx, int x, int z) {
        int randomY = ctx.f_226626_().m_216332_(ctx.f_226629_().m_141937_(), ctx.f_226629_().m_151558_());
        Holder holder = ctx.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)randomY), QuartPos.m_175400_((int)z), ctx.f_226624_().m_224579_());
        return ctx.f_226630_().test(holder);
    }

    private float airRatio(NoiseColumn column, int y, int height, int searchStep) {
        int airCount = 0;
        for (int i = y; i < y + height && i > y - height; i += searchStep) {
            BlockState state = column.m_183556_(i);
            if (!state.m_60795_() && !state.m_247087_()) continue;
            ++airCount;
        }
        return (float)airCount / (float)height;
    }

    private int findY(NoiseColumn column, BiPredicate<BlockState, BlockState> isCorrectBase, int searchStep, int seaLevel, int maxHeight) {
        int y;
        BlockState state = column.m_183556_(y - searchStep);
        for (y = searchStep > 0 ? seaLevel : maxHeight - 1; y < maxHeight && y >= seaLevel; y += searchStep) {
            BlockState before = state;
            state = column.m_183556_(y);
            if (isCorrectBase.test(state, before)) break;
        }
        return y;
    }

    public record Config(ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("location").forGetter(cfg -> cfg.location), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.offsetY), (App)StructurePlacementType.CODEC.fieldOf("placement").orElse((Object)StructurePlacementType.FLOOR).forGetter(cfg -> cfg.type), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.chance))).apply((Applicative)instance, Config::new));
    }
}

