/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import org.betterx.bclib.api.v2.levelgen.structures.BCLBaseStructureBuilder;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;

public class BCLJigsawStructureBuilder
extends BCLBaseStructureBuilder<JigsawStructure, BCLJigsawStructureBuilder> {
    private ResourceKey<StructureTemplatePool> startPool;
    private Optional<ResourceLocation> startJigsawName;
    private int maxDepth = 6;
    private HeightProvider startHeight = ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0));
    private boolean useExpansionHack = false;
    private Optional<Heightmap.Types> projectStartToHeightmap;
    private int maxDistanceFromCenter = 80;

    public BCLJigsawStructureBuilder(ResourceLocation structureID) {
        super(structureID, null);
        this.startJigsawName = Optional.empty();
        this.projectStartToHeightmap = Optional.empty();
    }

    public BCLJigsawStructureBuilder projectStartToHeightmap(Heightmap.Types value) {
        this.projectStartToHeightmap = Optional.of(value);
        return this;
    }

    public BCLJigsawStructureBuilder maxDistanceFromCenter(int value) {
        this.maxDistanceFromCenter = value;
        return this;
    }

    public BCLJigsawStructureBuilder startJigsawName(ResourceLocation value) {
        this.startJigsawName = Optional.of(value);
        return this;
    }

    public BCLJigsawStructureBuilder useExpansionHack(boolean value) {
        this.useExpansionHack = value;
        return this;
    }

    public BCLJigsawStructureBuilder maxDepth(int value) {
        this.maxDepth = value;
        return this;
    }

    public BCLJigsawStructureBuilder startHeight(HeightProvider value) {
        this.startHeight = value;
        return this;
    }

    public BCLJigsawStructureBuilder startPool(ResourceKey<StructureTemplatePool> pool) {
        this.startPool = pool;
        return this;
    }

    @Override
    protected Codec<JigsawStructure> getCodec() {
        return JigsawStructure.f_227604_;
    }

    @Override
    public BCLStructure<JigsawStructure> build() {
        if (this.startPool == null) {
            throw new IllegalStateException("Start pool must be set for " + this.structureID);
        }
        this.structureBuilder = (structureSettings, ctx) -> {
            HolderGetter templateGetter = ctx.m_255420_(Registries.f_256948_);
            return new JigsawStructure(structureSettings, (Holder)templateGetter.m_255043_(this.startPool), this.startJigsawName, this.maxDepth, this.startHeight, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter);
        };
        return super.build();
    }
}

