/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function15;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.BlocksHelper;

public abstract class ScatterFeatureConfig
implements FeatureConfiguration {
    public final BlockStateProvider clusterBlock;
    public final BlockStateProvider tipBlock;
    public final BlockStateProvider bottomBlock;
    public final Optional<BlockState> baseState;
    public final float baseReplaceChance;
    public final float chanceOfDirectionalSpread;
    public final float chanceOfSpreadRadius2;
    public final float chanceOfSpreadRadius3;
    public final int minHeight;
    public final int maxHeight;
    public final float maxSpread;
    public final float sizeVariation;
    public final float floorChance;
    public final IntProvider spreadCount;
    public final boolean growWhileFree;

    public ScatterFeatureConfig(BlockStateProvider clusterBlock, Optional<BlockStateProvider> tipBlock, Optional<BlockStateProvider> bottomBlock, Optional<BlockState> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, IntProvider spreadCount) {
        this.clusterBlock = clusterBlock;
        this.tipBlock = tipBlock.orElse(clusterBlock);
        this.bottomBlock = bottomBlock.orElse(clusterBlock);
        this.baseState = baseState;
        this.baseReplaceChance = baseReplaceChance;
        this.chanceOfDirectionalSpread = chanceOfDirectionalSpread;
        this.chanceOfSpreadRadius2 = chanceOfSpreadRadius2;
        this.chanceOfSpreadRadius3 = chanceOfSpreadRadius3;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.maxSpread = maxSpread;
        this.sizeVariation = sizeVariation;
        this.floorChance = floorChance;
        this.growWhileFree = growWhileFree;
        this.spreadCount = spreadCount;
    }

    public boolean isFloor(RandomSource random) {
        return random.m_188501_() < this.floorChance;
    }

    public abstract boolean isValidBase(BlockState var1);

    public abstract BlockState createBlock(int var1, int var2, RandomSource var3, BlockPos var4);

    public static <T extends ScatterFeatureConfig> Codec<T> buildCodec(Instancer<T> instancer) {
        return RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("cluster_block").forGetter(cfg -> cfg.clusterBlock), (App)BlockStateProvider.f_68747_.optionalFieldOf("tip_block").orElse(Optional.empty()).forGetter(cfg -> cfg.tipBlock == cfg.clusterBlock ? Optional.empty() : Optional.of(cfg.tipBlock)), (App)BlockStateProvider.f_68747_.optionalFieldOf("bottom_block").orElse(Optional.empty()).forGetter(cfg -> cfg.bottomBlock == cfg.clusterBlock ? Optional.empty() : Optional.of(cfg.bottomBlock)), (App)BlockState.f_61039_.optionalFieldOf("base_state").forGetter(cfg -> cfg.baseState), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("baseReplaceChance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.baseReplaceChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_directional_spread").orElse((Object)Float.valueOf(0.7f)).forGetter(cfg -> Float.valueOf(cfg.chanceOfDirectionalSpread)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spread_radius2").orElse((Object)Float.valueOf(0.5f)).forGetter(cfg -> Float.valueOf(cfg.chanceOfSpreadRadius2)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spread_radius3").orElse((Object)Float.valueOf(0.5f)).forGetter(cfg -> Float.valueOf(cfg.chanceOfSpreadRadius3)), (App)Codec.intRange((int)1, (int)64).fieldOf("min_height").orElse((Object)2).forGetter(cfg -> cfg.minHeight), (App)Codec.intRange((int)1, (int)64).fieldOf("max_height").orElse((Object)7).forGetter(cfg -> cfg.maxHeight), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("max_spread").orElse((Object)Float.valueOf(2.0f)).forGetter(cfg -> Float.valueOf(cfg.maxSpread)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("size_variation").orElse((Object)Float.valueOf(0.7f)).forGetter(cfg -> Float.valueOf(cfg.sizeVariation)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("floor_chance").orElse((Object)Float.valueOf(0.5f)).forGetter(cfg -> Float.valueOf(cfg.floorChance)), (App)Codec.BOOL.fieldOf("grow_while_empty").orElse((Object)false).forGetter(cfg -> cfg.growWhileFree), (App)IntProvider.m_146545_((int)0, (int)64).fieldOf("length").orElse((Object)UniformInt.m_146622_((int)0, (int)3)).forGetter(cfg -> cfg.spreadCount)).apply((Applicative)instance, (Function15)instancer));
    }

    public static Builder<OnSolid> startOnSolid() {
        return Builder.start(OnSolid::new);
    }

    public static Builder<ExtendTop> startExtendTop() {
        return Builder.start(ExtendTop::new);
    }

    public static Builder<ExtendBottom> startExtendBottom() {
        return Builder.start(ExtendBottom::new);
    }

    public static interface Instancer<T extends ScatterFeatureConfig>
    extends Function15<BlockStateProvider, Optional<BlockStateProvider>, Optional<BlockStateProvider>, Optional<BlockState>, Float, Float, Float, Float, Integer, Integer, Float, Float, Float, Boolean, IntProvider, T> {
    }

    public static class Builder<T extends ScatterFeatureConfig> {
        private BlockStateProvider clusterBlock;
        private BlockStateProvider tipBlock;
        private BlockStateProvider bottomBlock;
        private Optional<BlockState> baseState = Optional.empty();
        private float baseReplaceChance = 0.0f;
        private float chanceOfDirectionalSpread = 0.0f;
        private float chanceOfSpreadRadius2 = 0.0f;
        private float chanceOfSpreadRadius3 = 0.0f;
        private int minHeight = 2;
        private int maxHeight = 12;
        private float maxSpread = 0.0f;
        private float sizeVariation = 0.0f;
        private float floorChance = 0.5f;
        private boolean growWhileFree = false;
        public IntProvider spreadCount = ConstantInt.m_146483_((int)0);
        private final Instancer<T> instancer;

        public Builder(Instancer<T> instancer) {
            this.instancer = instancer;
        }

        public static <T extends ScatterFeatureConfig> Builder<T> start(Instancer<T> instancer) {
            return new Builder<T>(instancer);
        }

        public Builder<T> block(Block b) {
            return this.block(b.m_49966_());
        }

        public Builder<T> singleBlock(Block b) {
            return this.block(b.m_49966_()).heightRange(1, 1).spread(0.0f, 0.0f, (IntProvider)ConstantInt.m_146483_((int)0));
        }

        public Builder<T> block(BlockState s) {
            this.clusterBlock = BlockStateProvider.m_191384_((BlockState)s);
            if (this.tipBlock == null) {
                this.tipBlock = BlockStateProvider.m_191384_((BlockState)s);
            }
            if (this.bottomBlock == null) {
                this.bottomBlock = BlockStateProvider.m_191384_((BlockState)s);
            }
            return this;
        }

        public Builder<T> tipBlock(BlockState s) {
            this.tipBlock = BlockStateProvider.m_191384_((BlockState)s);
            return this;
        }

        public Builder<T> bottomBlock(BlockState s) {
            this.bottomBlock = BlockStateProvider.m_191384_((BlockState)s);
            return this;
        }

        public Builder<T> tripleShape(Block s) {
            return this.tripleShape(s.m_49966_());
        }

        public Builder<T> tripleShape(BlockState s) {
            this.block((BlockState)s.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)));
            this.tipBlock((BlockState)s.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
            this.bottomBlock((BlockState)s.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
            return this;
        }

        public Builder<T> tripleShapeCeil(Block s) {
            return this.tripleShapeCeil(s.m_49966_());
        }

        public Builder<T> tripleShapeCeil(BlockState s) {
            this.block((BlockState)s.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)));
            this.tipBlock((BlockState)s.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
            this.bottomBlock((BlockState)s.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
            return this;
        }

        public Builder<T> block(BlockStateProvider s) {
            this.clusterBlock = s;
            if (this.tipBlock == null) {
                this.tipBlock = s;
            }
            if (this.bottomBlock == null) {
                this.bottomBlock = s;
            }
            return this;
        }

        public Builder<T> tipBlock(BlockStateProvider s) {
            this.tipBlock = s;
            return this;
        }

        public Builder<T> bottomBlock(BlockStateProvider s) {
            this.bottomBlock = s;
            return this;
        }

        public Builder<T> heightRange(int min, int max) {
            this.minHeight = min;
            this.maxHeight = max;
            return this;
        }

        public Builder<T> growWhileFree() {
            this.growWhileFree = true;
            return this;
        }

        public Builder<T> minHeight(int h) {
            this.minHeight = h;
            return this;
        }

        public Builder<T> maxHeight(int h) {
            this.maxHeight = h;
            return this;
        }

        public Builder<T> generateBaseBlock(BlockState baseState) {
            return this.generateBaseBlock(baseState, 1.0f, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> generateBaseBlock(BlockState baseState, float baseReplaceChance) {
            return this.generateBaseBlock(baseState, baseReplaceChance, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> generateBaseBlock(BlockState baseState, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3) {
            return this.generateBaseBlock(baseState, 1.0f, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3);
        }

        public Builder<T> generateBaseBlock(BlockState baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3) {
            if (this.baseState.isPresent() && this.baseReplaceChance == 0.0f) {
                BCLib.LOGGER.error("Base generation was already selected.");
            }
            this.baseState = Optional.of(baseState);
            this.baseReplaceChance = baseReplaceChance;
            this.chanceOfDirectionalSpread = chanceOfDirectionalSpread;
            this.chanceOfSpreadRadius2 = chanceOfSpreadRadius2;
            this.chanceOfSpreadRadius3 = chanceOfSpreadRadius3;
            return this;
        }

        public Builder<T> noSpread() {
            return this.spread(0.0f, 0.0f, (IntProvider)ConstantInt.m_146483_((int)0));
        }

        public Builder<T> spread(float maxSpread, float sizeVariation) {
            return this.spread(maxSpread, sizeVariation, (IntProvider)ConstantInt.m_146483_((int)((int)Math.min(16.0f, 4.0f * maxSpread * maxSpread))));
        }

        public Builder<T> spread(float maxSpread, float sizeVariation, IntProvider spreadCount) {
            this.spreadCount = spreadCount;
            this.maxSpread = maxSpread;
            this.sizeVariation = sizeVariation;
            return this;
        }

        public Builder<T> floorChance(float chance) {
            this.floorChance = chance;
            return this;
        }

        public Builder<T> onFloor() {
            this.floorChance = 1.0f;
            return this;
        }

        public Builder<T> onCeil() {
            this.floorChance = 0.0f;
            return this;
        }

        public T build() {
            return (T)((ScatterFeatureConfig)this.instancer.apply(this.clusterBlock, Optional.of(this.tipBlock), Optional.of(this.bottomBlock), this.baseState, Float.valueOf(this.baseReplaceChance), Float.valueOf(this.chanceOfDirectionalSpread), Float.valueOf(this.chanceOfSpreadRadius2), Float.valueOf(this.chanceOfSpreadRadius3), this.minHeight, this.maxHeight, Float.valueOf(this.maxSpread), Float.valueOf(this.sizeVariation), Float.valueOf(this.floorChance), this.growWhileFree, this.spreadCount));
        }
    }

    public static class ExtendBottom
    extends ScatterFeatureConfig {
        public static final Codec<ExtendBottom> CODEC = ExtendBottom.buildCodec(ExtendBottom::new);

        protected ExtendBottom(BlockStateProvider clusterBlock, Optional<BlockStateProvider> tipBlock, Optional<BlockStateProvider> bottomBlock, Optional<BlockState> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, IntProvider spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        @Override
        public boolean isValidBase(BlockState state) {
            return BlocksHelper.isTerrain(state) || this.baseState.map(s -> state.m_60713_(s.m_60734_())).orElse(false) != false;
        }

        @Override
        public BlockState createBlock(int height, int maxHeight, RandomSource random, BlockPos pos) {
            if (height == maxHeight) {
                return this.tipBlock.m_213972_(random, pos);
            }
            if (height == maxHeight - 1) {
                return this.clusterBlock.m_213972_(random, pos);
            }
            return this.bottomBlock.m_213972_(random, pos);
        }
    }

    public static class ExtendTop
    extends ScatterFeatureConfig {
        public static final Codec<ExtendTop> CODEC = ExtendTop.buildCodec(ExtendTop::new);

        protected ExtendTop(BlockStateProvider clusterBlock, Optional<BlockStateProvider> tipBlock, Optional<BlockStateProvider> bottomBlock, Optional<BlockState> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, IntProvider spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        @Override
        public boolean isValidBase(BlockState state) {
            return BlocksHelper.isTerrain(state) || this.baseState.map(s -> state.m_60713_(s.m_60734_())).orElse(false) != false;
        }

        @Override
        public BlockState createBlock(int height, int maxHeight, RandomSource random, BlockPos pos) {
            if (height == 0) {
                return this.bottomBlock.m_213972_(random, pos);
            }
            if (height == 1) {
                return this.clusterBlock.m_213972_(random, pos);
            }
            return this.tipBlock.m_213972_(random, pos);
        }
    }

    public static class OnSolid
    extends ScatterFeatureConfig {
        public static final Codec<OnSolid> CODEC = OnSolid.buildCodec(OnSolid::new);

        protected OnSolid(BlockStateProvider clusterBlock, Optional<BlockStateProvider> tipBlock, Optional<BlockStateProvider> bottomBlock, Optional<BlockState> baseState, float baseReplaceChance, float chanceOfDirectionalSpread, float chanceOfSpreadRadius2, float chanceOfSpreadRadius3, int minHeight, int maxHeight, float maxSpread, float sizeVariation, float floorChance, boolean growWhileFree, IntProvider spreadCount) {
            super(clusterBlock, tipBlock, bottomBlock, baseState, baseReplaceChance, chanceOfDirectionalSpread, chanceOfSpreadRadius2, chanceOfSpreadRadius3, minHeight, maxHeight, maxSpread, sizeVariation, floorChance, growWhileFree, spreadCount);
        }

        @Override
        public boolean isValidBase(BlockState state) {
            return BlocksHelper.isTerrain(state) || this.baseState.map(s -> state.m_60713_(s.m_60734_())).orElse(false) != false;
        }

        @Override
        public BlockState createBlock(int height, int maxHeight, RandomSource random, BlockPos pos) {
            if (height == 0) {
                return this.bottomBlock.m_213972_(random, pos);
            }
            return height == maxHeight ? this.tipBlock.m_213972_(random, pos) : this.clusterBlock.m_213972_(random, pos);
        }
    }
}

