/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.config.MapBuilderFunction;
import org.betterx.bclib.api.v2.generator.map.hex.HexBiomeMap;
import org.betterx.bclib.api.v2.generator.map.square.SquareBiomeMap;
import org.betterx.worlds.together.biomesource.config.BiomeSourceConfig;
import org.jetbrains.annotations.NotNull;

public class BCLEndBiomeSourceConfig
implements BiomeSourceConfig<BCLibEndBiomeSource> {
    public static final BCLEndBiomeSourceConfig VANILLA = new BCLEndBiomeSourceConfig(EndBiomeMapType.VANILLA, EndBiomeGeneratorType.VANILLA, true, 4096, 128, 128, 128, 128);
    public static final BCLEndBiomeSourceConfig MINECRAFT_17 = new BCLEndBiomeSourceConfig(EndBiomeMapType.SQUARE, EndBiomeGeneratorType.PAULEVS, true, BCLEndBiomeSourceConfig.VANILLA.innerVoidRadiusSquared * 16 * 16, 256, 256, 256, 256);
    public static final BCLEndBiomeSourceConfig MINECRAFT_18 = new BCLEndBiomeSourceConfig(EndBiomeMapType.HEX, BCLib.RUNS_NULLSCAPE ? EndBiomeGeneratorType.VANILLA : EndBiomeGeneratorType.PAULEVS, !BCLib.RUNS_NULLSCAPE, BCLEndBiomeSourceConfig.MINECRAFT_17.innerVoidRadiusSquared, BCLEndBiomeSourceConfig.MINECRAFT_17.centerBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_17.voidBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_17.landBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_17.barrensBiomesSize);
    public static final BCLEndBiomeSourceConfig MINECRAFT_18_LARGE = new BCLEndBiomeSourceConfig(EndBiomeMapType.HEX, BCLib.RUNS_NULLSCAPE ? EndBiomeGeneratorType.VANILLA : EndBiomeGeneratorType.PAULEVS, !BCLib.RUNS_NULLSCAPE, BCLEndBiomeSourceConfig.MINECRAFT_18.innerVoidRadiusSquared, BCLEndBiomeSourceConfig.MINECRAFT_18.centerBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.voidBiomesSize * 2, BCLEndBiomeSourceConfig.MINECRAFT_18.landBiomesSize * 4, BCLEndBiomeSourceConfig.MINECRAFT_18.barrensBiomesSize * 2);
    public static final BCLEndBiomeSourceConfig MINECRAFT_18_AMPLIFIED = new BCLEndBiomeSourceConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.PAULEVS, true, BCLEndBiomeSourceConfig.MINECRAFT_18.innerVoidRadiusSquared, BCLEndBiomeSourceConfig.MINECRAFT_18.centerBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.voidBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.landBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.barrensBiomesSize);
    public static final BCLEndBiomeSourceConfig MINECRAFT_20 = new BCLEndBiomeSourceConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.VANILLA, !BCLib.RUNS_NULLSCAPE, BCLEndBiomeSourceConfig.MINECRAFT_17.innerVoidRadiusSquared, BCLEndBiomeSourceConfig.MINECRAFT_17.centerBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_17.voidBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_17.landBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_17.barrensBiomesSize);
    public static final BCLEndBiomeSourceConfig MINECRAFT_20_LARGE = new BCLEndBiomeSourceConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.VANILLA, !BCLib.RUNS_NULLSCAPE, BCLEndBiomeSourceConfig.MINECRAFT_18.innerVoidRadiusSquared, BCLEndBiomeSourceConfig.MINECRAFT_18.centerBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.voidBiomesSize * 2, BCLEndBiomeSourceConfig.MINECRAFT_18.landBiomesSize * 4, BCLEndBiomeSourceConfig.MINECRAFT_18.barrensBiomesSize * 2);
    public static final BCLEndBiomeSourceConfig MINECRAFT_20_AMPLIFIED = new BCLEndBiomeSourceConfig(EndBiomeMapType.HEX, EndBiomeGeneratorType.VANILLA, true, BCLEndBiomeSourceConfig.MINECRAFT_18.innerVoidRadiusSquared, BCLEndBiomeSourceConfig.MINECRAFT_18.centerBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.voidBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.landBiomesSize, BCLEndBiomeSourceConfig.MINECRAFT_18.barrensBiomesSize);
    public static final BCLEndBiomeSourceConfig DEFAULT = MINECRAFT_20;
    public static final Codec<BCLEndBiomeSourceConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EndBiomeMapType.CODEC.fieldOf("map_type").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.mapVersion).forGetter(o -> o.mapVersion), (App)EndBiomeGeneratorType.CODEC.fieldOf("generator_version").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.generatorVersion).forGetter(o -> o.generatorVersion), (App)Codec.BOOL.fieldOf("with_void_biomes").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.withVoidBiomes).forGetter(o -> o.withVoidBiomes), (App)Codec.INT.fieldOf("inner_void_radius_squared").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.innerVoidRadiusSquared).forGetter(o -> o.innerVoidRadiusSquared), (App)Codec.INT.fieldOf("center_biomes_size").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.centerBiomesSize).forGetter(o -> o.centerBiomesSize), (App)Codec.INT.fieldOf("void_biomes_size").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.voidBiomesSize).forGetter(o -> o.voidBiomesSize), (App)Codec.INT.fieldOf("land_biomes_size").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.landBiomesSize).forGetter(o -> o.landBiomesSize), (App)Codec.INT.fieldOf("barrens_biomes_size").orElse((Object)BCLEndBiomeSourceConfig.DEFAULT.barrensBiomesSize).forGetter(o -> o.barrensBiomesSize)).apply((Applicative)instance, BCLEndBiomeSourceConfig::new));
    @NotNull
    public final EndBiomeMapType mapVersion;
    @NotNull
    public final EndBiomeGeneratorType generatorVersion;
    public final boolean withVoidBiomes;
    public final int innerVoidRadiusSquared;
    public final int voidBiomesSize;
    public final int centerBiomesSize;
    public final int landBiomesSize;
    public final int barrensBiomesSize;

    public BCLEndBiomeSourceConfig(@NotNull EndBiomeMapType mapVersion, @NotNull EndBiomeGeneratorType generatorVersion, boolean withVoidBiomes, int innerVoidRadiusSquared, int centerBiomesSize, int voidBiomesSize, int landBiomesSize, int barrensBiomesSize) {
        this.mapVersion = mapVersion;
        this.generatorVersion = generatorVersion;
        this.withVoidBiomes = withVoidBiomes;
        this.innerVoidRadiusSquared = innerVoidRadiusSquared;
        this.barrensBiomesSize = Mth.m_14045_((int)barrensBiomesSize, (int)1, (int)8192);
        this.voidBiomesSize = Mth.m_14045_((int)voidBiomesSize, (int)1, (int)8192);
        this.centerBiomesSize = Mth.m_14045_((int)centerBiomesSize, (int)1, (int)8192);
        this.landBiomesSize = Mth.m_14045_((int)landBiomesSize, (int)1, (int)8192);
    }

    public String toString() {
        return "BCLEndBiomeSourceConfig{mapVersion=" + this.mapVersion + ", generatorVersion=" + this.generatorVersion + ", withVoidBiomes=" + this.withVoidBiomes + ", innerVoidRadiusSquared=" + this.innerVoidRadiusSquared + ", voidBiomesSize=" + this.voidBiomesSize + ", centerBiomesSize=" + this.centerBiomesSize + ", landBiomesSize=" + this.landBiomesSize + ", barrensBiomesSize=" + this.barrensBiomesSize + "}";
    }

    @Override
    public boolean couldSetWithoutRepair(BiomeSourceConfig<?> input) {
        if (input instanceof BCLEndBiomeSourceConfig) {
            BCLEndBiomeSourceConfig cfg = (BCLEndBiomeSourceConfig)input;
            return this.withVoidBiomes == cfg.withVoidBiomes && this.mapVersion == cfg.mapVersion && this.generatorVersion == cfg.generatorVersion;
        }
        return false;
    }

    @Override
    public boolean sameConfig(BiomeSourceConfig<?> input) {
        return this.equals(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BCLEndBiomeSourceConfig that = (BCLEndBiomeSourceConfig)o;
        return this.withVoidBiomes == that.withVoidBiomes && this.innerVoidRadiusSquared == that.innerVoidRadiusSquared && this.voidBiomesSize == that.voidBiomesSize && this.centerBiomesSize == that.centerBiomesSize && this.landBiomesSize == that.landBiomesSize && this.barrensBiomesSize == that.barrensBiomesSize && this.mapVersion == that.mapVersion && this.generatorVersion == that.generatorVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mapVersion, this.generatorVersion, this.withVoidBiomes, this.innerVoidRadiusSquared, this.voidBiomesSize, this.centerBiomesSize, this.landBiomesSize, this.barrensBiomesSize});
    }

    public static enum EndBiomeMapType implements StringRepresentable
    {
        VANILLA("vanilla", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker)),
        SQUARE("square", (seed, biomeSize, picker) -> new SquareBiomeMap(seed, biomeSize, picker)),
        HEX("hex", (seed, biomeSize, picker) -> new HexBiomeMap(seed, biomeSize, picker));

        public static final Codec<EndBiomeMapType> CODEC;
        public final String name;
        @NotNull
        public final MapBuilderFunction mapBuilder;

        private EndBiomeMapType(String name, MapBuilderFunction mapBuilder) {
            this.name = name;
            this.mapBuilder = mapBuilder;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(EndBiomeMapType::values);
        }
    }

    public static enum EndBiomeGeneratorType implements StringRepresentable
    {
        VANILLA("vanilla"),
        PAULEVS("paulevs");

        public static final Codec<EndBiomeGeneratorType> CODEC;
        public final String name;

        private EndBiomeGeneratorType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(EndBiomeGeneratorType::values);
        }
    }
}

