/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.util.WeighTree;
import org.betterx.bclib.util.WeightedList;
import org.betterx.worlds.together.world.event.WorldBootstrap;

public class BiomePicker {
    private final Map<BCLBiome, ActualBiome> all = new HashMap<BCLBiome, ActualBiome>();
    public final HolderGetter<Biome> biomeRegistry;
    private final List<ActualBiome> biomes = Lists.newArrayList();
    private final List<String> allowedBiomes;
    public final ActualBiome fallbackBiome;
    private WeighTree<ActualBiome> tree;

    BiomePicker() {
        this(WorldBootstrap.getLastRegistryAccess() == null ? null : (Registry)WorldBootstrap.getLastRegistryAccess().m_6632_(Registries.f_256952_).orElse(null));
    }

    public BiomePicker(Registry<Biome> biomeRegistry) {
        this((HolderGetter<Biome>)(biomeRegistry != null ? biomeRegistry.m_255303_() : null), null);
    }

    public BiomePicker(HolderGetter<Biome> biomeRegistry) {
        this(biomeRegistry, null);
    }

    public BiomePicker(HolderGetter<Biome> biomeRegistry, List<Holder<Biome>> allowedBiomes) {
        this.biomeRegistry = biomeRegistry;
        this.allowedBiomes = allowedBiomes != null ? allowedBiomes.stream().map(h -> h.m_203543_()).filter(o -> o.isPresent()).map(o -> ((ResourceKey)o.get()).m_135782_().toString()).toList() : null;
        this.fallbackBiome = this.create(BCLBiomeRegistry.EMPTY_BIOME);
    }

    private boolean isAllowed(BCLBiome b) {
        if (this.allowedBiomes == null) {
            return true;
        }
        return this.allowedBiomes.contains(b.getID().toString());
    }

    private ActualBiome create(BCLBiome bclBiome) {
        ActualBiome e = this.all.get(bclBiome);
        if (e != null) {
            return e;
        }
        return new ActualBiome(bclBiome);
    }

    public void addBiome(BCLBiome biome) {
        this.biomes.add(this.create(biome));
    }

    public ActualBiome getBiome(WorldgenRandom random) {
        return this.biomes.isEmpty() ? this.fallbackBiome : this.tree.get(random);
    }

    public boolean isEmpty() {
        return this.biomes.isEmpty();
    }

    public void rebuild() {
        ActualBiome biome2;
        WeightedList<ActualBiome> list = new WeightedList<ActualBiome>();
        this.biomes.forEach(biome -> {
            if (biome.isValid) {
                list.add((ActualBiome)biome, biome.bclBiome.settings.getGenChance());
            }
        });
        if (list.size() == 1 && (biome2 = (ActualBiome)list.get(0)).getEdge() != null) {
            float defaultBiomeSize = 128.0f;
            float edgeSize = (float)biome2.bclBiome.settings.getEdgeSize() * list.getWeight(0) / defaultBiomeSize;
            list.add(biome2.getEdge(), edgeSize);
        }
        if (list.isEmpty()) {
            list.add(this.create(BCLBiomeRegistry.EMPTY_BIOME), 1.0f);
        }
        this.tree = new WeighTree(list);
    }

    public String toString() {
        return "BiomePicker{biomes=" + this.biomes.size() + " (" + this.all.size() + "), biomeRegistry=" + this.biomeRegistry + ", type=" + super.toString() + "}";
    }

    public class ActualBiome {
        public final BCLBiome bclBiome;
        public final Holder<Biome> biome;
        public final ResourceKey<Biome> key;
        private final WeightedList<ActualBiome> subbiomes = new WeightedList();
        private final ActualBiome edge;
        private final ActualBiome parent;
        public final boolean isValid;

        private ActualBiome(BCLBiome bclBiome) {
            BiomePicker.this.all.put(bclBiome, this);
            this.bclBiome = bclBiome;
            this.key = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)bclBiome.getID());
            this.biome = this.key != null && BiomePicker.this.biomeRegistry != null ? BiomePicker.this.biomeRegistry.m_255043_(this.key) : null;
            this.isValid = this.key != null && this.biome != null && this.biome.m_203633_() && BiomePicker.this.biomeRegistry.m_254902_(this.key).isPresent();
            bclBiome.forEachSubBiome((b, w) -> {
                if (BiomePicker.this.isAllowed((BCLBiome)b)) {
                    this.subbiomes.add(BiomePicker.this.create((BCLBiome)b), w.floatValue());
                }
            });
            this.edge = bclBiome.hasEdge() && BiomePicker.this.isAllowed(bclBiome.getEdge()) ? BiomePicker.this.create(bclBiome.getEdge()) : null;
            this.parent = bclBiome.getParentBiome() != null ? BiomePicker.this.create(bclBiome.getParentBiome()) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActualBiome entry = (ActualBiome)o;
            return this.bclBiome.equals(entry.bclBiome);
        }

        public int hashCode() {
            return Objects.hash(this.bclBiome);
        }

        public ActualBiome getSubBiome(WorldgenRandom random) {
            return this.subbiomes.get((RandomSource)random);
        }

        public ActualBiome getEdge() {
            return this.edge;
        }

        public ActualBiome getParentBiome() {
            return this.parent;
        }

        public boolean isSame(ActualBiome e) {
            return this.bclBiome.isSame(e.bclBiome);
        }

        public String toString() {
            return "ActualBiome{key=" + this.key.m_135782_() + ", subbiomes=" + this.subbiomes.size() + ", edge=" + (Comparable)(this.edge != null ? this.edge.key.m_135782_() : "null") + ", parent=" + (Comparable)(this.parent != null ? this.parent.key.m_135782_() : "null") + ", isValid=" + this.isValid + "}";
        }
    }
}

