/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;

public class LifeCycleAPI {
    private static final List<LevelLoadBiomesCall> onLoadLevelBiomes = new ArrayList<LevelLoadBiomesCall>(2);
    private static final List<LevelLoadCall> onLoadLevel = new ArrayList<LevelLoadCall>(2);
    private static final List<BeforeLevelLoadCall> beforeLoadLevel = new ArrayList<BeforeLevelLoadCall>(2);

    public static void beforeLevelLoad(BeforeLevelLoadCall call) {
        beforeLoadLevel.add(call);
    }

    public static void onLevelLoad(LevelLoadBiomesCall call) {
        onLoadLevelBiomes.add(call);
    }

    public static void onLevelLoad(LevelLoadCall call) {
        onLoadLevel.add(call);
    }

    public static void _runBeforeLevelLoad() {
        beforeLoadLevel.forEach(c -> c.beforeLoad());
    }

    public static void _runLevelLoad(ServerLevel world, MinecraftServer minecraftServer, Executor executor, LevelStorageSource.LevelStorageAccess levelStorageAccess, ServerLevelData serverLevelData, ResourceKey<Level> resourceKey, ChunkProgressListener chunkProgressListener, boolean bl, long l, List<CustomSpawner> list, boolean bl2) {
        onLoadLevel.forEach(c -> c.onLoad(world, minecraftServer, executor, levelStorageAccess, serverLevelData, resourceKey, chunkProgressListener, bl, l, list, bl2));
        long seed = world.m_7328_();
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        onLoadLevelBiomes.forEach(c -> c.onLoad(world, seed, (Registry<Biome>)biomeRegistry));
    }

    public static interface LevelLoadBiomesCall {
        public void onLoad(ServerLevel var1, long var2, Registry<Biome> var4);
    }

    public static interface LevelLoadCall {
        public void onLoad(ServerLevel var1, MinecraftServer var2, Executor var3, LevelStorageSource.LevelStorageAccess var4, ServerLevelData var5, ResourceKey<Level> var6, ChunkProgressListener var7, boolean var8, long var9, List<CustomSpawner> var11, boolean var12);
    }

    public static interface BeforeLevelLoadCall {
        public void beforeLoad();
    }
}

