/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.util;

import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.client.resource.EBEPack;
import foundationgames.enhancedblockentities.util.EBEUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import org.jetbrains.annotations.Nullable;

public final class ResourceUtil
extends Enum<ResourceUtil> {
    private static EBEPack BASE_PACK;
    private static EBEPack TOP_LEVEL_PACK;
    private static final /* synthetic */ ResourceUtil[] $VALUES;

    public static ResourceUtil[] values() {
        return (ResourceUtil[])$VALUES.clone();
    }

    public static ResourceUtil valueOf(String name) {
        return Enum.valueOf(ResourceUtil.class, name);
    }

    public static String createChestItemModelResource(String centerChest) {
        return "{\"parent\":\"block/" + centerChest + "\",\"overrides\":[{\"predicate\":{\"ebe:is_christmas\":1},\"model\": \"item/christmas_chest\"}]}";
    }

    private static JVariant variantRotation16(JVariant variant, String keyPrefix, String modelPrefix) {
        return variant.put(keyPrefix + "0", JState.model((String)(modelPrefix + "_0")).y(180)).put(keyPrefix + "1", JState.model((String)(modelPrefix + "_67_5")).y(270)).put(keyPrefix + "2", JState.model((String)(modelPrefix + "_45")).y(270)).put(keyPrefix + "3", JState.model((String)(modelPrefix + "_22_5")).y(270)).put(keyPrefix + "4", JState.model((String)(modelPrefix + "_0")).y(270)).put(keyPrefix + "5", JState.model((String)(modelPrefix + "_67_5"))).put(keyPrefix + "6", JState.model((String)(modelPrefix + "_45"))).put(keyPrefix + "7", JState.model((String)(modelPrefix + "_22_5"))).put(keyPrefix + "8", JState.model((String)(modelPrefix + "_0"))).put(keyPrefix + "9", JState.model((String)(modelPrefix + "_67_5")).y(90)).put(keyPrefix + "10", JState.model((String)(modelPrefix + "_45")).y(90)).put(keyPrefix + "11", JState.model((String)(modelPrefix + "_22_5")).y(90)).put(keyPrefix + "12", JState.model((String)(modelPrefix + "_0")).y(90)).put(keyPrefix + "13", JState.model((String)(modelPrefix + "_67_5")).y(180)).put(keyPrefix + "14", JState.model((String)(modelPrefix + "_45")).y(180)).put(keyPrefix + "15", JState.model((String)(modelPrefix + "_22_5")).y(180));
    }

    private static JVariant variantHFacing(JVariant variant, String keyPrefix, String model) {
        return variant.put(keyPrefix + "north", JState.model((String)model)).put(keyPrefix + "west", JState.model((String)model).y(270)).put(keyPrefix + "south", JState.model((String)model).y(180)).put(keyPrefix + "east", JState.model((String)model).y(90));
    }

    public static void addSingleChestModels(String texture, String chestName, EBEPack pack) {
        pack.addModel(JModel.model().parent("block/template_chest_center").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", texture), chestName)), new ResourceLocation("block/" + chestName + "_center"));
        pack.addModel(JModel.model().parent("block/template_chest_center_lid").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", texture), chestName)), new ResourceLocation("block/" + chestName + "_center_lid"));
        pack.addModel(JModel.model().parent("block/template_chest_center_trunk").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", texture), chestName)), new ResourceLocation("block/" + chestName + "_center_trunk"));
    }

    public static void addDoubleChestModels(String leftTex, String rightTex, String chestName, EBEPack pack) {
        pack.addModel(JModel.model().parent("block/template_chest_left").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", leftTex), chestName)), new ResourceLocation("block/" + chestName + "_left"));
        pack.addModel(JModel.model().parent("block/template_chest_left_lid").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", leftTex), chestName)), new ResourceLocation("block/" + chestName + "_left_lid"));
        pack.addModel(JModel.model().parent("block/template_chest_left_trunk").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", leftTex), chestName)), new ResourceLocation("block/" + chestName + "_left_trunk"));
        pack.addModel(JModel.model().parent("block/template_chest_right").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", rightTex), chestName)), new ResourceLocation("block/" + chestName + "_right"));
        pack.addModel(JModel.model().parent("block/template_chest_right_lid").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", rightTex), chestName)), new ResourceLocation("block/" + chestName + "_right_lid"));
        pack.addModel(JModel.model().parent("block/template_chest_right_trunk").textures(ResourceUtil.withChestParticle(JModel.textures().var("chest", rightTex), chestName)), new ResourceLocation("block/" + chestName + "_right_trunk"));
    }

    private static JTextures withChestParticle(JTextures textures, String chestName) {
        if (EnhancedBlockEntities.CONFIG.experimentalChests) {
            textures.var("particle", "block/" + chestName + "_particle");
        }
        return textures;
    }

    private static JTextures withBedParticle(JTextures textures, String bedColor) {
        if (EnhancedBlockEntities.CONFIG.experimentalBeds) {
            textures.var("particle", "block/" + bedColor + "_bed_particle");
        }
        return textures;
    }

    private static JTextures withSignParticle(JTextures textures, String signName) {
        if (EnhancedBlockEntities.CONFIG.experimentalSigns) {
            textures.var("particle", "block/" + signName + "_particle");
        }
        return textures;
    }

    public static void addChestBlockStates(String chestName, EBEPack pack) {
        JVariant variant = JState.variant();
        ResourceUtil.variantHFacing(variant, "type=single,facing=", "builtin:" + chestName + "_center");
        ResourceUtil.variantHFacing(variant, "type=left,facing=", "builtin:" + chestName + "_left");
        ResourceUtil.variantHFacing(variant, "type=right,facing=", "builtin:" + chestName + "_right");
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation(chestName));
    }

    public static void addSingleChestOnlyBlockStates(String chestName, EBEPack pack) {
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{ResourceUtil.variantHFacing(JState.variant(), "facing=", "builtin:" + chestName + "_center")}), new ResourceLocation(chestName));
    }

    public static void addSignTypeModels(String signType, EBEPack pack) {
        String signName = signType + "_sign";
        String signTex = "entity/signs/" + signType;
        ResourceUtil.addRotation16Models(ResourceUtil.withSignParticle(new JTextures().var("sign", signTex), signName), "block/template_sign", "block/" + signName, ResourceUtil::signAOSuffix, pack);
        JTextures hangingTexDef = new JTextures().var("sign", "entity/signs/hanging/" + signType).var("particle", "block/particle_hanging_sign_" + signType);
        ResourceUtil.addRotation16Models(hangingTexDef, "block/template_hanging_sign", "block/" + signType + "_hanging_sign", ResourceUtil::signAOSuffix, pack);
        ResourceUtil.addRotation16Models(hangingTexDef, "block/template_hanging_sign_attached", "block/" + signType + "_hanging_sign_attached", ResourceUtil::signAOSuffix, pack);
        pack.addModel(JModel.model().parent(ResourceUtil.signAOSuffix("block/template_wall_sign")).textures(ResourceUtil.withSignParticle(JModel.textures().var("sign", signTex), signName)), new ResourceLocation("block/" + signType + "_wall_sign"));
        pack.addModel(JModel.model().parent(ResourceUtil.signAOSuffix("block/template_wall_hanging_sign")).textures(hangingTexDef), new ResourceLocation("block/" + signType + "_wall_hanging_sign"));
    }

    public static void addRotation16Models(JTextures textures, String templatePrefix, String modelPrefix, Function<String, String> suffix, EBEPack pack) {
        pack.addModel(JModel.model().parent(suffix.apply(templatePrefix + "_0")).textures(textures), new ResourceLocation(modelPrefix + "_0"));
        pack.addModel(JModel.model().parent(suffix.apply(templatePrefix + "_22_5")).textures(textures), new ResourceLocation(modelPrefix + "_22_5"));
        pack.addModel(JModel.model().parent(suffix.apply(templatePrefix + "_45")).textures(textures), new ResourceLocation(modelPrefix + "_45"));
        pack.addModel(JModel.model().parent(suffix.apply(templatePrefix + "_67_5")).textures(textures), new ResourceLocation(modelPrefix + "_67_5"));
    }

    private static String signAOSuffix(String model) {
        if (EnhancedBlockEntities.CONFIG.signAO) {
            model = (String)model + "_ao";
        }
        return model;
    }

    public static void addSignBlockStates(String signName, String wallSignName, EBEPack pack) {
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{ResourceUtil.variantRotation16(JState.variant(), "rotation=", "block/" + signName)}), new ResourceLocation(signName));
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{ResourceUtil.variantHFacing(JState.variant(), "facing=", "block/" + wallSignName)}), new ResourceLocation(wallSignName));
    }

    public static void addHangingSignBlockStates(String signName, String wallSignName, EBEPack pack) {
        JVariant variant = JState.variant();
        ResourceUtil.variantRotation16(variant, "attached=false,rotation=", "block/" + signName);
        ResourceUtil.variantRotation16(variant, "attached=true,rotation=", "block/" + signName + "_attached");
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation(signName));
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{ResourceUtil.variantHFacing(JState.variant(), "facing=", "block/" + wallSignName)}), new ResourceLocation(wallSignName));
    }

    public static void addBellBlockState(EBEPack pack) {
        JVariant variant = JState.variant();
        for (Direction dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
            int rot = (int)dir.m_122435_() + 90;
            variant.put("attachment=double_wall,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_between_walls").y(rot)).put("attachment=ceiling,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_ceiling").y(rot + 90)).put("attachment=floor,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_floor").y(rot + 90)).put("attachment=single_wall,facing=" + dir.m_122433_(), JState.model((String)"builtin:bell_wall").y(rot));
        }
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation("bell"));
    }

    public static void addBedModels(DyeColor bedColor, EBEPack pack) {
        String color = bedColor.m_41065_();
        pack.addModel(JModel.model().parent(ResourceUtil.bedAOSuffix("block/template_bed_head")).textures(ResourceUtil.withBedParticle(JModel.textures().var("bed", "entity/bed/" + color), color)), new ResourceLocation("block/" + color + "_bed_head"));
        pack.addModel(JModel.model().parent(ResourceUtil.bedAOSuffix("block/template_bed_foot")).textures(ResourceUtil.withBedParticle(JModel.textures().var("bed", "entity/bed/" + color), color)), new ResourceLocation("block/" + color + "_bed_foot"));
    }

    public static void addBedBlockState(DyeColor bedColor, EBEPack pack) {
        String color = bedColor.m_41065_();
        JVariant variant = JState.variant();
        for (Direction dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
            int rot = (int)dir.m_122435_() + 180;
            variant.put("part=head,facing=" + dir.m_122433_(), JState.model((String)("block/" + bedColor + "_bed_head")).y(rot)).put("part=foot,facing=" + dir.m_122433_(), JState.model((String)("block/" + bedColor + "_bed_foot")).y(rot));
        }
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation(color + "_bed"));
    }

    private static String bedAOSuffix(String model) {
        if (EnhancedBlockEntities.CONFIG.bedAO) {
            model = (String)model + "_ao";
        }
        return model;
    }

    public static void addShulkerBoxModels(@Nullable DyeColor color, EBEPack pack) {
        String texture = color != null ? "entity/shulker/shulker_" + color.m_41065_() : "entity/shulker/shulker";
        String shulkerBoxStr = color != null ? color.m_41065_() + "_shulker_box" : "shulker_box";
        String particle = "block/" + shulkerBoxStr;
        pack.addModel(JModel.model().parent("block/template_shulker_box").textures(JModel.textures().var("shulker", texture).var("particle", particle)), new ResourceLocation("block/" + shulkerBoxStr));
        pack.addModel(JModel.model().parent("block/template_shulker_box_bottom").textures(JModel.textures().var("shulker", texture).var("particle", particle)), new ResourceLocation("block/" + shulkerBoxStr + "_bottom"));
        pack.addModel(JModel.model().parent("block/template_shulker_box_lid").textures(JModel.textures().var("shulker", texture).var("particle", particle)), new ResourceLocation("block/" + shulkerBoxStr + "_lid"));
    }

    public static void addShulkerBoxBlockStates(@Nullable DyeColor color, EBEPack pack) {
        String shulkerBoxStr = color != null ? color.m_41065_() + "_shulker_box" : "shulker_box";
        JVariant variant = JState.variant().put("facing=up", JState.model((String)("builtin:" + shulkerBoxStr))).put("facing=down", JState.model((String)("builtin:" + shulkerBoxStr)).x(180));
        for (Direction dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
            int rot = (int)dir.m_122435_() + 180;
            variant.put("facing=" + dir.m_122433_(), JState.model((String)("builtin:" + shulkerBoxStr)).x(90).y(rot));
        }
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), new ResourceLocation(shulkerBoxStr));
    }

    public static void addDecoratedPotBlockState(EBEPack pack) {
        pack.addBlockState(JState.state((JVariant[])new JVariant[]{ResourceUtil.variantHFacing(JState.variant(), "facing=", "builtin:decorated_pot")}), new ResourceLocation("decorated_pot"));
    }

    public static void addDecoratedPotPatternModels(ResourceKey<String> patternKey, EBEPack pack) {
        for (Direction dir : EBEUtil.HORIZONTAL_DIRECTIONS) {
            pack.addModel(JModel.model().parent("block/template_pottery_pattern_" + dir.m_122433_()).textures(JModel.textures().var("pattern", DecoratedPotPatterns.m_271757_(patternKey).toString())), new ResourceLocation("block/" + patternKey.m_135782_().m_135815_() + "_" + dir.m_122433_()));
        }
    }

    public static void resetBasePack() {
        BASE_PACK = new EBEPack(EBEUtil.id("base_resources"));
    }

    public static void resetTopLevelPack() {
        TOP_LEVEL_PACK = new EBEPack(EBEUtil.id("top_level_resources"));
    }

    public static EBEPack getBasePack() {
        return BASE_PACK;
    }

    public static EBEPack getTopLevelPack() {
        return TOP_LEVEL_PACK;
    }

    public static EBEPack getPackForCompat() {
        if (EnhancedBlockEntities.CONFIG.forceResourcePackCompat) {
            return ResourceUtil.getTopLevelPack();
        }
        return ResourceUtil.getBasePack();
    }

    public static void dumpModAssets(Path dest) throws IOException {
        List roots = FabricLoader.getInstance().getModContainer("enhancedblockentities").map(ModContainer::getRootPaths).orElse(List.of());
        for (Path root : roots) {
            Stream<Path> sourceAssets = Files.walk(root.resolve("assets"), new FileVisitOption[0]);
            for (Path asset : sourceAssets.collect(Collectors.toSet())) {
                CopyOption[] copyOptionArray;
                if (Files.isDirectory(asset, new LinkOption[0])) continue;
                Path out = dest.resolve(root.relativize(asset));
                if (!Files.exists(out.getParent(), new LinkOption[0])) {
                    Files.createDirectories(out.getParent(), new FileAttribute[0]);
                }
                if (Files.exists(out, new LinkOption[0])) {
                    CopyOption[] copyOptionArray2 = new CopyOption[1];
                    copyOptionArray = copyOptionArray2;
                    copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                } else {
                    copyOptionArray = new CopyOption[]{};
                }
                Files.copy(asset, out, copyOptionArray);
            }
        }
    }

    public static void dumpAllPacks(Path dest) throws IOException {
        ResourceUtil.getBasePack().dumpDirect(dest);
        ResourceUtil.getTopLevelPack().dumpDirect(dest);
        ResourceUtil.dumpModAssets(dest);
    }

    private static /* synthetic */ ResourceUtil[] $values() {
        return new ResourceUtil[0];
    }

    static {
        $VALUES = ResourceUtil.$values();
        ResourceUtil.resetBasePack();
        ResourceUtil.resetTopLevelPack();
    }
}

