/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.DirtTexturedBackground;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.util.RenderUtil;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.ReloadType;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.config.gui.option.EBEOption;
import foundationgames.enhancedblockentities.config.gui.option.TextPalette;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.GuiUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class EBEConfigScreen
extends SpruceScreen {
    private SpruceOptionListWidget optionsWidget;
    private List<EBEOption> options = new ArrayList<EBEOption>();
    private final Screen parent;
    private static final ImmutableList<String> BOOLEAN_OPTIONS = ImmutableList.of((Object)"true", (Object)"false");
    private static final ImmutableList<String> ALLOWED_FORCED_DISABLED = ImmutableList.of((Object)"allowed", (Object)"forced", (Object)"disabled");
    private static final ImmutableList<String> SIGN_TEXT_OPTIONS = ImmutableList.of((Object)"smart", (Object)"all", (Object)"most", (Object)"some", (Object)"few");
    private static final Component HOLD_SHIFT = Component.m_237115_((String)"text.ebe.descriptions").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
    private static final String CHEST_OPTIONS_TITLE = "text.ebe.chest_options";
    private static final String SIGN_OPTIONS_TITLE = "text.ebe.sign_options";
    private static final String BELL_OPTIONS_TITLE = "text.ebe.bell_options";
    private static final String BED_OPTIONS_TITLE = "text.ebe.bed_options";
    private static final String SHULKER_BOX_OPTIONS_TITLE = "text.ebe.shulker_box_options";
    private static final String DECORATED_POT_OPTIONS_TITLE = "text.ebe.decorated_pot_options";
    private static final String ADVANCED_TITLE = "text.ebe.advanced";
    private static final Component DUMP_LABEL = Component.m_237115_((String)"option.ebe.dump");
    private final Component dumpTooltip = GuiUtil.shorten(I18n.m_118938_((String)"option.ebe.dump.comment", (Object[])new Object[0]), 20, new ChatFormatting[0]);
    private final PanoramaRenderer background = new PanoramaRenderer(TitleScreen.f_96716_);

    public EBEConfigScreen(Screen screen) {
        super((Component)Component.m_237115_((String)"screen.ebe.config"));
        this.parent = screen;
    }

    protected void m_7856_() {
        super.m_7856_();
        int bottomCenter = this.f_96543_ / 2 - 50;
        this.optionsWidget = new SpruceOptionListWidget(Position.of((int)0, (int)34), this.f_96543_, this.f_96544_ - 69);
        this.options.clear();
        this.optionsWidget.setBackground((Background)new DirtTexturedBackground(32, 32, 32, 0));
        this.addOptions();
        this.m_142416_((GuiEventListener)this.optionsWidget);
        this.m_142416_((GuiEventListener)new SpruceButtonWidget(Position.of((int)(bottomCenter - 104), (int)(this.f_96544_ - 27)), 100, 20, CommonComponents.f_130656_, button -> this.m_7379_()));
        this.m_142416_((GuiEventListener)new SpruceButtonWidget(Position.of((int)bottomCenter, (int)(this.f_96544_ - 27)), 100, 20, (Component)Component.m_237115_((String)"text.ebe.apply"), button -> this.applyChanges()));
        this.m_142416_((GuiEventListener)new SpruceButtonWidget(Position.of((int)(bottomCenter + 104), (int)(this.f_96544_ - 27)), 100, 20, CommonComponents.f_130655_, button -> {
            this.applyChanges();
            this.m_7379_();
        }));
    }

    public void m_280039_(GuiGraphics context) {
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.f_96541_.f_91073_ == null) {
            this.background.m_110003_(delta, 1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
        }
        context.m_280024_(0, 0, this.f_96543_, this.f_96544_, 0x4F141414, 0x4F141414);
        RenderUtil.renderBackgroundTexture((int)0, (int)0, (int)this.f_96543_, (int)34, (float)0.0f);
        RenderUtil.renderBackgroundTexture((int)0, (int)(this.f_96544_ - 35), (int)this.f_96543_, (int)35, (float)0.0f);
        super.m_88315_(context, mouseX, mouseY, delta);
        context.m_280653_(this.f_96547_, this.f_96539_, (int)((double)this.f_96543_ * 0.5), 8, 0xFFFFFF);
        context.m_280653_(this.f_96547_, HOLD_SHIFT, (int)((double)this.f_96543_ * 0.5), 21, 0xFFFFFF);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public void applyChanges() {
        EBEConfig config = EnhancedBlockEntities.CONFIG;
        Properties properties = new Properties();
        AtomicReference<ReloadType> type = new AtomicReference<ReloadType>(ReloadType.NONE);
        this.options.forEach(option -> {
            if (!option.isDefault()) {
                type.set(((ReloadType)((Object)((Object)type.get()))).or(option.reloadType));
            }
            properties.setProperty(option.key, option.getValue());
        });
        config.readFrom(properties);
        config.save();
        EnhancedBlockEntities.reload(type.get());
    }

    public void addOptions() {
        Properties config = new Properties();
        EnhancedBlockEntities.CONFIG.writeTo(config);
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(CHEST_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_chests", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_chests")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("chest_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("chest_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addOptionEntry(this.option(new EBEOption("experimental_chests", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("experimental_chests")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)), this.option(new EBEOption("christmas_chests", (List<String>)ALLOWED_FORCED_DISABLED, ALLOWED_FORCED_DISABLED.indexOf((Object)config.getProperty("christmas_chests")), true, TextPalette.rainbow(0.35f), ReloadType.WORLD)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(SIGN_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_signs", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_signs")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("sign_text_rendering", (List<String>)SIGN_TEXT_OPTIONS, SIGN_TEXT_OPTIONS.indexOf((Object)config.getProperty("sign_text_rendering")), true, TextPalette.rainbow(0.45f), ReloadType.NONE)));
        this.optionsWidget.addOptionEntry(this.option(new EBEOption("experimental_signs", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("experimental_signs")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)), this.option(new EBEOption("sign_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("sign_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(BELL_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_bells", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_bells")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("bell_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("bell_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(BED_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_beds", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_beds")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addOptionEntry(this.option(new EBEOption("experimental_beds", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("experimental_beds")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)), this.option(new EBEOption("bed_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("bed_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(SHULKER_BOX_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_shulker_boxes", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_shulker_boxes")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("shulker_box_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("shulker_box_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(DECORATED_POT_OPTIONS_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("render_enhanced_decorated_pots", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("render_enhanced_decorated_pots")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("decorated_pot_ao", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("decorated_pot_ao")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(ADVANCED_TITLE, true, null));
        this.optionsWidget.addSingleOptionEntry(this.option(new EBEOption("force_resource_pack_compat", (List<String>)BOOLEAN_OPTIONS, BOOLEAN_OPTIONS.indexOf((Object)config.getProperty("force_resource_pack_compat")), false, TextPalette.ON_OFF, ReloadType.RESOURCES)));
        this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceCyclingOption("option.ebe.dump", i -> {
            try {
                EBEUtil.dumpResources();
            }
            catch (IOException e) {
                EnhancedBlockEntities.LOG.error((Object)e);
            }
        }, o -> DUMP_LABEL, this.dumpTooltip));
    }

    private SpruceOption option(EBEOption option) {
        this.options.add(option);
        return new SpruceCyclingOption(option.getOptionKey(), i -> option.next(), o -> option.getText(), (Component)option.getTooltip());
    }
}

