/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.config.gui.option;

import foundationgames.enhancedblockentities.ReloadType;
import foundationgames.enhancedblockentities.config.gui.option.TextPalette;
import foundationgames.enhancedblockentities.util.GuiUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public final class EBEOption {
    private static final Component NEWLINE = Component.m_130674_((String)"\n");
    private static final String OPTION_VALUE = "options.generic_value";
    private static final String DIVIDER = "text.ebe.option_value_division";
    public final String key;
    public final boolean hasValueComments;
    public final Component comment;
    public final ReloadType reloadType;
    public final TextPalette palette;
    private final List<String> values;
    private final int defaultValue;
    private int selected;
    private MutableComponent tooltip = null;
    private Component text = null;

    public EBEOption(String key, List<String> values, int defaultValue, boolean hasValueComments, TextPalette palette, ReloadType reloadType) {
        this.key = key;
        this.values = values;
        this.selected = this.defaultValue = Mth.m_14045_((int)defaultValue, (int)0, (int)values.size());
        this.hasValueComments = hasValueComments;
        this.palette = palette;
        this.reloadType = reloadType;
        String commentKey = I18n.m_118938_((String)String.format("option.ebe.%s.comment", key), (Object[])new Object[0]);
        this.comment = GuiUtil.shorten(commentKey, 20, new ChatFormatting[0]);
    }

    public String getValue() {
        return this.values.get(this.selected);
    }

    public String getOptionKey() {
        return String.format("option.ebe.%s", this.key);
    }

    public String getValueKey() {
        return String.format("value.ebe.%s", this.getValue());
    }

    public Component getText() {
        MutableComponent option = Component.m_237115_((String)this.getOptionKey()).m_130938_(style -> style.m_178520_(this.isDefault() ? 0xFFFFFF : 16767582));
        MutableComponent value = Component.m_237115_((String)this.getValueKey()).m_130938_(style -> style.m_178520_(this.palette.getColor((float)this.selected / (float)this.values.size())));
        if (this.text == null) {
            this.text = option.m_7220_((Component)Component.m_237115_((String)DIVIDER).m_7220_((Component)value));
        }
        return this.text;
    }

    public MutableComponent getTooltip() {
        if (this.tooltip == null) {
            this.tooltip = this.hasValueComments ? Component.m_237115_((String)String.format("option.ebe.%s.valueComment.%s", this.key, this.getValue())).m_7220_(NEWLINE).m_7220_((Component)this.comment.m_6879_()) : this.comment.m_6879_();
        }
        return this.tooltip;
    }

    public void next() {
        ++this.selected;
        if (this.selected >= this.values.size()) {
            this.selected = 0;
        }
        this.tooltip = null;
        this.text = null;
    }

    public boolean isDefault() {
        return this.selected == this.defaultValue;
    }
}

