/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.resource;

import foundationgames.enhancedblockentities.client.resource.AtlasResourceBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.util.CallableFunction;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class EBEPack
implements RuntimeResourcePack {
    public static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("blocks");
    private final RuntimeResourcePack resourcePack;
    private final Map<ResourceLocation, AtlasResourceBuilder> atlases = new HashMap<ResourceLocation, AtlasResourceBuilder>();

    public EBEPack(ResourceLocation id) {
        this.resourcePack = RuntimeResourcePack.create((ResourceLocation)id);
    }

    public void addAtlasSprite(ResourceLocation atlas, SpriteSource source) {
        AtlasResourceBuilder resource = this.atlases.computeIfAbsent(atlas, id -> new AtlasResourceBuilder());
        resource.put(source);
        this.addLazyResource(PackType.CLIENT_RESOURCES, new ResourceLocation(atlas.m_135827_(), "atlases/" + atlas.m_135815_() + ".json"), (pack, id) -> resource.toBytes());
    }

    public void addSingleBlockSprite(ResourceLocation path) {
        this.addAtlasSprite(BLOCK_ATLAS, (SpriteSource)new SingleFile(path, Optional.empty()));
    }

    public void addDirBlockSprites(String dir, String prefix) {
        this.addAtlasSprite(BLOCK_ATLAS, (SpriteSource)new DirectoryLister(dir, prefix));
    }

    public void addRecoloredImage(ResourceLocation identifier, InputStream target, IntUnaryOperator pixel) {
        this.resourcePack.addRecoloredImage(identifier, target, pixel);
    }

    public byte[] addLang(ResourceLocation identifier, JLang lang) {
        return this.resourcePack.addLang(identifier, lang);
    }

    public void mergeLang(ResourceLocation identifier, JLang lang) {
        this.resourcePack.mergeLang(identifier, lang);
    }

    public byte[] addLootTable(ResourceLocation identifier, JLootTable table) {
        return this.resourcePack.addLootTable(identifier, table);
    }

    public Future<byte[]> addAsyncResource(PackType type, ResourceLocation identifier, CallableFunction<ResourceLocation, byte[]> data) {
        return this.resourcePack.addAsyncResource(type, identifier, data);
    }

    public void addLazyResource(PackType type, ResourceLocation path, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> data) {
        this.resourcePack.addLazyResource(type, path, data);
    }

    public byte[] addResource(PackType type, ResourceLocation path, byte[] data) {
        return this.resourcePack.addResource(type, path, data);
    }

    public Future<byte[]> addAsyncRootResource(String path, CallableFunction<String, byte[]> data) {
        return this.resourcePack.addAsyncRootResource(path, data);
    }

    public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
        this.resourcePack.addLazyRootResource(path, data);
    }

    public byte[] addRootResource(String path, byte[] data) {
        return this.resourcePack.addRootResource(path, data);
    }

    public byte[] addAsset(ResourceLocation path, byte[] data) {
        return this.resourcePack.addAsset(path, data);
    }

    public byte[] addData(ResourceLocation path, byte[] data) {
        return this.resourcePack.addData(path, data);
    }

    public byte[] addModel(JModel model, ResourceLocation path) {
        return this.resourcePack.addModel(model, path);
    }

    public byte[] addBlockState(JState state, ResourceLocation path) {
        return this.resourcePack.addBlockState(state, path);
    }

    public byte[] addTexture(ResourceLocation id, BufferedImage image) {
        return this.resourcePack.addTexture(id, image);
    }

    public byte[] addAnimation(ResourceLocation id, JAnimation animation) {
        return this.resourcePack.addAnimation(id, animation);
    }

    public byte[] addTag(ResourceLocation id, JTag tag) {
        return this.resourcePack.addTag(id, tag);
    }

    public byte[] addRecipe(ResourceLocation id, JRecipe recipe) {
        return this.resourcePack.addRecipe(id, recipe);
    }

    public Future<?> async(Consumer<RuntimeResourcePack> action) {
        return this.resourcePack.async(action);
    }

    public void dumpDirect(Path path) {
        this.resourcePack.dumpDirect(path);
    }

    public void load(Path path) throws IOException {
        this.resourcePack.load(path);
    }

    public void dump(File file) {
        this.resourcePack.dump(file);
    }

    public void dump(ZipOutputStream stream) throws IOException {
        this.resourcePack.dump(stream);
    }

    public void load(ZipInputStream stream) throws IOException {
        this.resourcePack.load(stream);
    }

    public ResourceLocation getId() {
        return this.resourcePack.getId();
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... segments) {
        return this.resourcePack.m_8017_(segments);
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        return this.resourcePack.m_214146_(type, id);
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        this.resourcePack.m_8031_(type, namespace, prefix, consumer);
    }

    public Set<String> m_5698_(PackType type) {
        return this.resourcePack.m_5698_(type);
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) throws IOException {
        return (T)this.resourcePack.m_5550_(metaReader);
    }

    public String m_5542_() {
        return this.resourcePack.m_5542_();
    }

    public void close() {
        this.resourcePack.close();
    }
}

