/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.model.misc;

import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.model.ModelSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DecoratedPotModelSelector
extends ModelSelector {
    private final List<ResourceKey<String>> potteryPatterns = new ArrayList<ResourceKey<String>>(BuiltInRegistries.f_271353_.m_214010_());

    public DecoratedPotModelSelector() {
        super(5);
    }

    public ResourceLocation[] createModelIDs() {
        ModelIdentifiers.refreshPotteryPatterns();
        ResourceLocation[] ids = new ResourceLocation[1 + this.potteryPatterns.size() * 4];
        ids[0] = ModelIdentifiers.DECORATED_POT_BASE;
        int idIndex = 1;
        for (int dirIndex = 0; dirIndex < 4; ++dirIndex) {
            for (ResourceKey<String> pattern : this.potteryPatterns) {
                ids[idIndex] = ModelIdentifiers.POTTERY_PATTERNS.get(pattern)[dirIndex];
                ++idIndex;
            }
        }
        return ids;
    }

    @Override
    public void writeModelIndices(BlockAndTintGetter view, BlockState state, BlockPos pos, Supplier<RandomSource> rand, @Nullable RenderContext ctx, int[] indices) {
        int patternCount = this.potteryPatterns.size();
        indices[0] = 0;
        BlockEntity blockEntity = view.m_7702_(pos);
        if (blockEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity pot = (DecoratedPotBlockEntity)blockEntity;
            DecoratedPotBlockEntity.Decorations sherds = pot.m_284296_();
            indices[1] = 1 + this.getPatternIndex(sherds.f_283886_(), patternCount);
            indices[2] = 1 + this.getPatternIndex(sherds.f_283809_(), patternCount) + patternCount;
            indices[3] = 1 + this.getPatternIndex(sherds.f_283873_(), patternCount) + patternCount * 2;
            indices[4] = 1 + this.getPatternIndex(sherds.f_283810_(), patternCount) + patternCount * 3;
            return;
        }
        for (int i = 0; i < 4; ++i) {
            indices[1 + i] = 1 + patternCount * i;
        }
    }

    private int getPatternIndex(Item sherd, int max) {
        return Mth.m_14045_((int)this.potteryPatterns.indexOf(DecoratedPotPatterns.m_271696_((Item)sherd)), (int)0, (int)(max - 1));
    }
}

