/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.model;

import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.util.EBEUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public final class ModelIdentifiers {
    public static final Predicate<EBEConfig> CHEST_PREDICATE = c -> c.renderEnhancedChests;
    public static final Predicate<EBEConfig> BELL_PREDICATE = c -> c.renderEnhancedBells;
    public static final Predicate<EBEConfig> SHULKER_BOX_PREDICATE = c -> c.renderEnhancedShulkerBoxes;
    public static final Predicate<EBEConfig> DECORATED_POT_PREDICATE = c -> c.renderEnhancedDecoratedPots;
    public static final ResourceLocation CHEST_CENTER = ModelIdentifiers.of("block/chest_center", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/chest_center_trunk", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_CENTER_LID = ModelIdentifiers.of("block/chest_center_lid", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_LEFT = ModelIdentifiers.of("block/chest_left", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_LEFT_TRUNK = ModelIdentifiers.of("block/chest_left_trunk", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_LEFT_LID = ModelIdentifiers.of("block/chest_left_lid", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_RIGHT = ModelIdentifiers.of("block/chest_right", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_RIGHT_TRUNK = ModelIdentifiers.of("block/chest_right_trunk", CHEST_PREDICATE);
    public static final ResourceLocation CHEST_RIGHT_LID = ModelIdentifiers.of("block/chest_right_lid", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_CENTER = ModelIdentifiers.of("block/trapped_chest_center", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/trapped_chest_center_trunk", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_CENTER_LID = ModelIdentifiers.of("block/trapped_chest_center_lid", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_LEFT = ModelIdentifiers.of("block/trapped_chest_left", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_LEFT_TRUNK = ModelIdentifiers.of("block/trapped_chest_left_trunk", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_LEFT_LID = ModelIdentifiers.of("block/trapped_chest_left_lid", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_RIGHT = ModelIdentifiers.of("block/trapped_chest_right", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_RIGHT_TRUNK = ModelIdentifiers.of("block/trapped_chest_right_trunk", CHEST_PREDICATE);
    public static final ResourceLocation TRAPPED_CHEST_RIGHT_LID = ModelIdentifiers.of("block/trapped_chest_right_lid", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_CENTER = ModelIdentifiers.of("block/christmas_chest_center", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/christmas_chest_center_trunk", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_CENTER_LID = ModelIdentifiers.of("block/christmas_chest_center_lid", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_LEFT = ModelIdentifiers.of("block/christmas_chest_left", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_LEFT_TRUNK = ModelIdentifiers.of("block/christmas_chest_left_trunk", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_LEFT_LID = ModelIdentifiers.of("block/christmas_chest_left_lid", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_RIGHT = ModelIdentifiers.of("block/christmas_chest_right", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_RIGHT_TRUNK = ModelIdentifiers.of("block/christmas_chest_right_trunk", CHEST_PREDICATE);
    public static final ResourceLocation CHRISTMAS_CHEST_RIGHT_LID = ModelIdentifiers.of("block/christmas_chest_right_lid", CHEST_PREDICATE);
    public static final ResourceLocation ENDER_CHEST_CENTER = ModelIdentifiers.of("block/ender_chest_center", CHEST_PREDICATE);
    public static final ResourceLocation ENDER_CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/ender_chest_center_trunk", CHEST_PREDICATE);
    public static final ResourceLocation ENDER_CHEST_CENTER_LID = ModelIdentifiers.of("block/ender_chest_center_lid", CHEST_PREDICATE);
    public static final ResourceLocation BELL_BETWEEN_WALLS = ModelIdentifiers.of("block/bell_between_walls", BELL_PREDICATE);
    public static final ResourceLocation BELL_CEILING = ModelIdentifiers.of("block/bell_ceiling", BELL_PREDICATE);
    public static final ResourceLocation BELL_FLOOR = ModelIdentifiers.of("block/bell_floor", BELL_PREDICATE);
    public static final ResourceLocation BELL_WALL = ModelIdentifiers.of("block/bell_wall", BELL_PREDICATE);
    public static final ResourceLocation BELL_BETWEEN_WALLS_WITH_BELL = ModelIdentifiers.of("block/bell_between_walls_with_bell", BELL_PREDICATE);
    public static final ResourceLocation BELL_CEILING_WITH_BELL = ModelIdentifiers.of("block/bell_ceiling_with_bell", BELL_PREDICATE);
    public static final ResourceLocation BELL_FLOOR_WITH_BELL = ModelIdentifiers.of("block/bell_floor_with_bell", BELL_PREDICATE);
    public static final ResourceLocation BELL_WALL_WITH_BELL = ModelIdentifiers.of("block/bell_wall_with_bell", BELL_PREDICATE);
    public static final ResourceLocation BELL_BODY = ModelIdentifiers.of("block/bell_body", BELL_PREDICATE);
    public static final ResourceLocation DECORATED_POT_BASE = ModelIdentifiers.of("block/decorated_pot_base", DECORATED_POT_PREDICATE);
    public static final Map<DyeColor, ResourceLocation> SHULKER_BOXES = new HashMap<DyeColor, ResourceLocation>();
    public static final Map<DyeColor, ResourceLocation> SHULKER_BOX_BOTTOMS = new HashMap<DyeColor, ResourceLocation>();
    public static final Map<DyeColor, ResourceLocation> SHULKER_BOX_LIDS = new HashMap<DyeColor, ResourceLocation>();
    public static final Map<ResourceKey<String>, ResourceLocation[]> POTTERY_PATTERNS = new HashMap<ResourceKey<String>, ResourceLocation[]>();

    public static void init() {
    }

    public static void refreshPotteryPatterns() {
        POTTERY_PATTERNS.clear();
        Direction[] orderedHorizontalDirs = new Direction[]{Direction.NORTH, Direction.WEST, Direction.EAST, Direction.SOUTH};
        for (ResourceKey patternKey : BuiltInRegistries.f_271353_.m_214010_()) {
            String pattern = patternKey.m_135782_().m_135815_();
            ResourceLocation[] ids = new ResourceLocation[orderedHorizontalDirs.length];
            for (int i = 0; i < 4; ++i) {
                ids[i] = ModelIdentifiers.of("block/" + pattern + "_" + orderedHorizontalDirs[i].m_122433_(), DECORATED_POT_PREDICATE);
            }
            POTTERY_PATTERNS.put((ResourceKey<String>)patternKey, ids);
        }
    }

    private static ResourceLocation of(String id, Predicate<EBEConfig> condition) {
        ResourceLocation idf = new ResourceLocation(id);
        ModelLoadingRegistry.INSTANCE.registerModelProvider((resourceManager, consumer) -> {
            if (condition.test(EnhancedBlockEntities.CONFIG)) {
                consumer.accept(idf);
            }
        });
        return idf;
    }

    static {
        for (DyeColor color : EBEUtil.DEFAULTED_DYE_COLORS) {
            String id = color != null ? "block/" + color.m_41065_() + "_shulker_box" : "block/shulker_box";
            SHULKER_BOXES.put(color, ModelIdentifiers.of(id, SHULKER_BOX_PREDICATE));
            SHULKER_BOX_BOTTOMS.put(color, ModelIdentifiers.of(id + "_bottom", SHULKER_BOX_PREDICATE));
            SHULKER_BOX_LIDS.put(color, ModelIdentifiers.of(id + "_lid", SHULKER_BOX_PREDICATE));
        }
        ModelIdentifiers.refreshPotteryPatterns();
    }
}

