/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities;

import foundationgames.enhancedblockentities.EnhancedBlockEntityRegistry;
import foundationgames.enhancedblockentities.client.model.DynamicModelEffects;
import foundationgames.enhancedblockentities.client.model.DynamicModelProvider;
import foundationgames.enhancedblockentities.client.model.DynamicUnbakedModel;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.model.ModelSelector;
import foundationgames.enhancedblockentities.client.model.misc.DecoratedPotModelSelector;
import foundationgames.enhancedblockentities.client.render.BlockEntityRenderCondition;
import foundationgames.enhancedblockentities.client.render.BlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.BellBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.ChestBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.ShulkerBoxBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.render.entity.SignBlockEntityRendererOverride;
import foundationgames.enhancedblockentities.client.resource.EBEPack;
import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.ResourceUtil;
import foundationgames.enhancedblockentities.util.duck.BakedModelManagerAccess;
import java.util.function.Function;
import net.devtech.arrp.json.models.JModel;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public final class EBESetup
extends Enum<EBESetup> {
    private static final /* synthetic */ EBESetup[] $VALUES;

    public static EBESetup[] values() {
        return (EBESetup[])$VALUES.clone();
    }

    public static EBESetup valueOf(String name) {
        return Enum.valueOf(EBESetup.class, name);
    }

    public static void setupRRPChests() {
        EBEPack p = ResourceUtil.getPackForCompat();
        ResourceUtil.addChestBlockStates("chest", p);
        ResourceUtil.addChestBlockStates("trapped_chest", p);
        ResourceUtil.addChestBlockStates("christmas_chest", p);
        ResourceUtil.addSingleChestOnlyBlockStates("ender_chest", p);
        p = ResourceUtil.getBasePack();
        ResourceUtil.addSingleChestModels("entity/chest/normal", "chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/normal_left", "entity/chest/normal_right", "chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/trapped", "trapped_chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/trapped_left", "entity/chest/trapped_right", "trapped_chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/christmas", "christmas_chest", p);
        ResourceUtil.addDoubleChestModels("entity/chest/christmas_left", "entity/chest/christmas_right", "christmas_chest", p);
        ResourceUtil.addSingleChestModels("entity/chest/ender", "ender_chest", p);
        p.addResource(PackType.CLIENT_RESOURCES, new ResourceLocation("models/item/chest.json"), ResourceUtil.createChestItemModelResource("chest_center").getBytes());
        p.addResource(PackType.CLIENT_RESOURCES, new ResourceLocation("models/item/trapped_chest.json"), ResourceUtil.createChestItemModelResource("trapped_chest_center").getBytes());
        p.addModel(JModel.model((String)"block/ender_chest_center"), new ResourceLocation("item/ender_chest"));
        p.addDirBlockSprites("entity/chest", "entity/chest/");
    }

    public static void setupRRPSigns() {
        EBEPack p = ResourceUtil.getPackForCompat();
        ResourceUtil.addSignBlockStates("oak_sign", "oak_wall_sign", p);
        ResourceUtil.addSignBlockStates("birch_sign", "birch_wall_sign", p);
        ResourceUtil.addSignBlockStates("spruce_sign", "spruce_wall_sign", p);
        ResourceUtil.addSignBlockStates("jungle_sign", "jungle_wall_sign", p);
        ResourceUtil.addSignBlockStates("acacia_sign", "acacia_wall_sign", p);
        ResourceUtil.addSignBlockStates("dark_oak_sign", "dark_oak_wall_sign", p);
        ResourceUtil.addSignBlockStates("mangrove_sign", "mangrove_wall_sign", p);
        ResourceUtil.addSignBlockStates("cherry_sign", "cherry_wall_sign", p);
        ResourceUtil.addSignBlockStates("crimson_sign", "crimson_wall_sign", p);
        ResourceUtil.addSignBlockStates("warped_sign", "warped_wall_sign", p);
        ResourceUtil.addSignBlockStates("bamboo_sign", "bamboo_wall_sign", p);
        ResourceUtil.addHangingSignBlockStates("oak_hanging_sign", "oak_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("birch_hanging_sign", "birch_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("spruce_hanging_sign", "spruce_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("jungle_hanging_sign", "jungle_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("acacia_hanging_sign", "acacia_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("dark_oak_hanging_sign", "dark_oak_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("mangrove_hanging_sign", "mangrove_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("cherry_hanging_sign", "cherry_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("crimson_hanging_sign", "crimson_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("warped_hanging_sign", "warped_wall_hanging_sign", p);
        ResourceUtil.addHangingSignBlockStates("bamboo_hanging_sign", "bamboo_wall_hanging_sign", p);
        p = ResourceUtil.getBasePack();
        ResourceUtil.addSignTypeModels("oak", p);
        ResourceUtil.addSignTypeModels("birch", p);
        ResourceUtil.addSignTypeModels("spruce", p);
        ResourceUtil.addSignTypeModels("jungle", p);
        ResourceUtil.addSignTypeModels("acacia", p);
        ResourceUtil.addSignTypeModels("dark_oak", p);
        ResourceUtil.addSignTypeModels("mangrove", p);
        ResourceUtil.addSignTypeModels("cherry", p);
        ResourceUtil.addSignTypeModels("crimson", p);
        ResourceUtil.addSignTypeModels("warped", p);
        ResourceUtil.addSignTypeModels("bamboo", p);
        p.addDirBlockSprites("entity/signs", "entity/signs/");
        p.addDirBlockSprites("entity/signs/hanging", "entity/signs/hanging/");
        p.addDirBlockSprites("gui/hanging_signs", "block/particle_hanging_sign_");
    }

    public static void setupRRPBells() {
        ResourceUtil.addBellBlockState(ResourceUtil.getPackForCompat());
        ResourceUtil.getBasePack().addSingleBlockSprite(new ResourceLocation("entity/bell/bell_body"));
    }

    public static void setupRRPBeds() {
        EBEPack p = ResourceUtil.getBasePack();
        EBEPack pCompat = ResourceUtil.getPackForCompat();
        for (DyeColor color : DyeColor.values()) {
            ResourceUtil.addBedBlockState(color, pCompat);
            ResourceUtil.addBedModels(color, p);
        }
        p.addDirBlockSprites("entity/bed", "entity/bed/");
    }

    public static void setupRRPShulkerBoxes() {
        EBEPack p = ResourceUtil.getBasePack();
        EBEPack pCompat = ResourceUtil.getPackForCompat();
        for (DyeColor color : EBEUtil.DEFAULTED_DYE_COLORS) {
            String id = color != null ? color.m_41065_() + "_shulker_box" : "shulker_box";
            ResourceUtil.addShulkerBoxBlockStates(color, pCompat);
            ResourceUtil.addShulkerBoxModels(color, p);
            p.addModel(JModel.model((String)("block/" + id)), new ResourceLocation("item/" + id));
        }
        p.addDirBlockSprites("entity/shulker", "entity/shulker/");
    }

    public static void setupRRPDecoratedPots() {
        EBEPack p = ResourceUtil.getBasePack();
        EBEPack pCompat = ResourceUtil.getPackForCompat();
        ResourceUtil.addDecoratedPotBlockState(pCompat);
        for (ResourceKey patternKey : BuiltInRegistries.f_271353_.m_214010_()) {
            ResourceUtil.addDecoratedPotPatternModels((ResourceKey<String>)patternKey, p);
        }
        p.addDirBlockSprites("entity/decorated_pot", "entity/decorated_pot/");
    }

    public static void setupResourceProviders() {
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "chest_center"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.CHEST_CENTER, ModelIdentifiers.CHEST_CENTER_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_CENTER, ModelIdentifiers.CHRISTMAS_CHEST_CENTER_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "chest_left"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.CHEST_LEFT, ModelIdentifiers.CHEST_LEFT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_LEFT, ModelIdentifiers.CHRISTMAS_CHEST_LEFT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "chest_right"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.CHEST_RIGHT, ModelIdentifiers.CHEST_RIGHT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "trapped_chest_center"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.TRAPPED_CHEST_CENTER, ModelIdentifiers.TRAPPED_CHEST_CENTER_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_CENTER, ModelIdentifiers.CHRISTMAS_CHEST_CENTER_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "trapped_chest_left"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.TRAPPED_CHEST_LEFT, ModelIdentifiers.TRAPPED_CHEST_LEFT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_LEFT, ModelIdentifiers.CHRISTMAS_CHEST_LEFT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "trapped_chest_right"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.TRAPPED_CHEST_RIGHT, ModelIdentifiers.TRAPPED_CHEST_RIGHT_TRUNK, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT, ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_TRUNK}, ModelSelector.CHEST_WITH_CHRISTMAS, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "ender_chest_center"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.ENDER_CHEST_CENTER, ModelIdentifiers.ENDER_CHEST_CENTER_TRUNK}, ModelSelector.CHEST, DynamicModelEffects.CHEST)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_between_walls"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_BETWEEN_WALLS_WITH_BELL, ModelIdentifiers.BELL_BETWEEN_WALLS}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_ceiling"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_CEILING_WITH_BELL, ModelIdentifiers.BELL_CEILING}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_floor"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_FLOOR_WITH_BELL, ModelIdentifiers.BELL_FLOOR}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "bell_wall"), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.BELL_WALL_WITH_BELL, ModelIdentifiers.BELL_WALL}, ModelSelector.BELL, DynamicModelEffects.BELL)));
        for (DyeColor color : EBEUtil.DEFAULTED_DYE_COLORS) {
            ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", (String)(color != null ? color.m_41065_() + "_shulker_box" : "shulker_box")), () -> new DynamicUnbakedModel(new ResourceLocation[]{ModelIdentifiers.SHULKER_BOXES.get(color), ModelIdentifiers.SHULKER_BOX_BOTTOMS.get(color)}, ModelSelector.SHULKER_BOX, DynamicModelEffects.SHULKER_BOX)));
        }
        DecoratedPotModelSelector decoratedPotSelector = new DecoratedPotModelSelector();
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> new DynamicModelProvider(new ResourceLocation("builtin", "decorated_pot"), () -> new DynamicUnbakedModel(decoratedPotSelector.createModelIDs(), decoratedPotSelector, DynamicModelEffects.DECORATED_POT)));
    }

    public static void setupChests() {
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.f_50087_, RenderType.m_110457_());
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.f_50325_, RenderType.m_110457_());
        BlockRenderLayerMap.INSTANCE.putBlock(Blocks.f_50265_, RenderType.m_110457_());
        Function<BlockEntity, Integer> christmasChestSelector = entity -> {
            int os = DateUtil.isChristmas() ? 3 : 0;
            ChestType type = (ChestType)entity.m_58900_().m_61143_((Property)BlockStateProperties.f_61392_);
            return type == ChestType.RIGHT ? 2 + os : (type == ChestType.LEFT ? 1 + os : os);
        };
        EnhancedBlockEntityRegistry.register(Blocks.f_50087_, BlockEntityType.f_58918_, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
            return new BakedModel[]{manager.getModel(ModelIdentifiers.CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHEST_RIGHT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_LID)};
        }, christmasChestSelector));
        EnhancedBlockEntityRegistry.register(Blocks.f_50325_, BlockEntityType.f_58919_, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
            return new BakedModel[]{manager.getModel(ModelIdentifiers.TRAPPED_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.TRAPPED_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.TRAPPED_CHEST_RIGHT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_CENTER_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_LEFT_LID), manager.getModel(ModelIdentifiers.CHRISTMAS_CHEST_RIGHT_LID)};
        }, christmasChestSelector));
        EnhancedBlockEntityRegistry.register(Blocks.f_50265_, BlockEntityType.f_58920_, BlockEntityRenderCondition.CHEST, new ChestBlockEntityRendererOverride(() -> {
            BakedModelManagerAccess manager = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
            return new BakedModel[]{manager.getModel(ModelIdentifiers.ENDER_CHEST_CENTER_LID)};
        }, entity -> 0));
    }

    public static void setupSigns() {
        for (Block sign : new Block[]{Blocks.f_50095_, Blocks.f_50158_, Blocks.f_50150_, Blocks.f_50160_, Blocks.f_50149_, Blocks.f_50159_, Blocks.f_50152_, Blocks.f_50162_, Blocks.f_50151_, Blocks.f_50161_, Blocks.f_50153_, Blocks.f_50163_, Blocks.f_220841_, Blocks.f_220839_, Blocks.f_271516_, Blocks.f_271107_, Blocks.f_50673_, Blocks.f_50675_, Blocks.f_50674_, Blocks.f_50676_, Blocks.f_244433_, Blocks.f_244608_}) {
            EnhancedBlockEntityRegistry.register(sign, BlockEntityType.f_58924_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
        }
        for (Block sign : new Block[]{Blocks.f_244319_, Blocks.f_244093_, Blocks.f_243890_, Blocks.f_244296_, Blocks.f_244633_, Blocks.f_243895_, Blocks.f_244263_, Blocks.f_243897_, Blocks.f_243716_, Blocks.f_243773_, Blocks.f_243960_, Blocks.f_243998_, Blocks.f_244485_, Blocks.f_244385_, Blocks.f_271116_, Blocks.f_271427_, Blocks.f_244147_, Blocks.f_244281_, Blocks.f_244396_, Blocks.f_244241_, Blocks.f_244091_, Blocks.f_244462_}) {
            EnhancedBlockEntityRegistry.register(sign, BlockEntityType.f_244529_, BlockEntityRenderCondition.SIGN, new SignBlockEntityRendererOverride());
            BlockRenderLayerMap.INSTANCE.putBlock(sign, RenderType.m_110463_());
        }
    }

    public static void setupBells() {
        EnhancedBlockEntityRegistry.register(Blocks.f_50680_, BlockEntityType.f_58909_, BlockEntityRenderCondition.BELL, new BellBlockEntityRendererOverride());
    }

    public static void setupBeds() {
        EnhancedBlockEntityRegistry.register(Blocks.f_50029_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50025_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50026_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50023_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50021_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50027_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50017_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50022_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50019_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50068_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50067_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50020_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50024_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50028_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50066_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
        EnhancedBlockEntityRegistry.register(Blocks.f_50018_, BlockEntityType.f_58940_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
    }

    public static void setupShulkerBoxes() {
        for (DyeColor color : EBEUtil.DEFAULTED_DYE_COLORS) {
            Block block = ShulkerBoxBlock.m_56190_((DyeColor)color);
            BlockRenderLayerMap.INSTANCE.putBlock(block, RenderType.m_110457_());
            EnhancedBlockEntityRegistry.register(block, BlockEntityType.f_58939_, BlockEntityRenderCondition.SHULKER_BOX, new ShulkerBoxBlockEntityRendererOverride(map -> {
                BakedModelManagerAccess models = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
                for (DyeColor dc : EBEUtil.DEFAULTED_DYE_COLORS) {
                    map.put(dc, models.getModel(ModelIdentifiers.SHULKER_BOX_LIDS.get(dc)));
                }
            }));
        }
    }

    public static void setupDecoratedPots() {
        EnhancedBlockEntityRegistry.register(Blocks.f_271197_, BlockEntityType.f_271291_, BlockEntityRenderCondition.NEVER, BlockEntityRendererOverride.NO_OP);
    }

    private static /* synthetic */ EBESetup[] $values() {
        return new EBESetup[0];
    }

    static {
        $VALUES = EBESetup.$values();
    }
}

