/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells.eldritch;

import com.skydude.dacxirons.entity.spells.EldritchSlash.EldritchSlash;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.spells.eldritch.AbstractEldritchSpell;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.mcreator.dungeonsandcombat.init.DungeonsAndCombatModItems;
import net.mcreator.dungeonsandcombat.init.DungeonsAndCombatModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class EldritchSlashSpell
extends AbstractEldritchSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "eldritch_slash");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(5).setCooldownSeconds(15.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}));
    }

    public EldritchSlashSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 10;
        this.baseManaCost = 30;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)DungeonsAndCombatModSounds.KAMATH_STAB.get());
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = 3.25f;
        float distance = 1.9f;
        Vec3 forward = entity.m_20156_();
        Vec3 hitLocation = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.3f), 0.0).m_82549_(forward.m_82490_((double)distance));
        List entities = level.m_45933_((Entity)entity, AABB.m_165882_((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        SpellDamageSource damageSource = this.getDamageSource((Entity)entity);
        for (Entity targetEntity : entities) {
            Vec3 offsetVector;
            if (!(targetEntity instanceof LivingEntity) || !targetEntity.m_6084_() || !entity.m_6087_() || !(targetEntity.m_20182_().m_82546_(entity.m_146892_()).m_82526_(forward) >= 0.0) || !(entity.m_20280_(targetEntity) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.m_146892_(), (Vec3)targetEntity.m_20191_().m_82399_(), (boolean)true) || !((offsetVector = targetEntity.m_20191_().m_82399_().m_82546_(entity.m_146892_())).m_82526_(forward) >= 0.0) || !DamageSources.applyDamage((Entity)targetEntity, (float)this.getDamage(spellLevel, entity), (DamageSource)damageSource)) continue;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.ELECTRIC_SPARKS, (double)targetEntity.m_20185_(), (double)(targetEntity.m_20186_() + (double)(targetEntity.m_20206_() * 0.5f)), (double)targetEntity.m_20189_(), (int)50, (double)(targetEntity.m_20205_() * 0.5f), (double)(targetEntity.m_20206_() * 0.5f), (double)(targetEntity.m_20205_() * 0.5f), (double)0.03, (boolean)false);
            EnchantmentHelper.m_44896_((LivingEntity)entity, (Entity)targetEntity);
        }
        boolean mirrored = playerMagicData.getCastingEquipmentSlot().equals(SpellSelectionManager.OFFHAND);
        EldritchSlash eldritchSlash = new EldritchSlash(level, mirrored);
        eldritchSlash.m_20219_(hitLocation);
        eldritchSlash.m_146922_(entity.m_146908_());
        eldritchSlash.m_146926_(entity.m_146909_());
        level.m_7967_((Entity)eldritchSlash);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return (this.getSpellPower(spellLevel, (Entity)entity) + Utils.getWeaponDamage((LivingEntity)entity, (MobType)MobType.f_21640_)) * 1.35f * this.holdingoath(entity);
    }

    private String getDamageText(int spellLevel, LivingEntity entity) {
        if (entity != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)entity, (MobType)MobType.f_21640_);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, entity), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)entity);
    }

    public float holdingoath(LivingEntity living) {
        if (living.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == DungeonsAndCombatModItems.OATH_SWORD.get()) {
            return 1.3f;
        }
        return 1.0f;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ONE_HANDED_HORIZONTAL_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }
}

