/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.fireball.MagicFireball;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.mcreator.dungeonsandcombat.DungeonsAndCombatMod;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class TripleFireballSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "triple_fireball_spell");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237115_((String)"ui.dacxirons.triple_fireball_ballamount"), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{this.getRadius(spellLevel, caster)}));
    }

    public TripleFireballSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
        this.baseManaCost = 120;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIREBALL_START.get());
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        DungeonsAndCombatMod.queueServerWork((int)10, () -> this.spawnFireballOnce(world, entity, spellLevel));
        DungeonsAndCombatMod.queueServerWork((int)20, () -> {
            world.m_247517_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.FIRE_CAST.get(), SoundSource.PLAYERS);
            this.spawnFireballOnce(world, entity, spellLevel);
        });
        DungeonsAndCombatMod.queueServerWork((int)30, () -> {
            world.m_247517_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.FIRE_CAST.get(), SoundSource.PLAYERS);
            this.spawnFireballOnce(world, entity, spellLevel);
        });
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnFireballOnce(Level world, LivingEntity caster, int spellLevel) {
        if (caster == null || !caster.m_6084_()) {
            return;
        }
        Vec3 origin = caster.m_146892_();
        MagicFireball fireball = new MagicFireball(world, caster);
        fireball.setDamage(this.getDamage(spellLevel, caster));
        System.out.println(fireball.m_269291_());
        fireball.setExplosionRadius((float)this.getRadius(spellLevel, caster));
        fireball.m_146884_(origin.m_82549_(caster.m_20156_()).m_82492_(0.0, (double)fireball.m_20206_() / 2.0, 0.0));
        fireball.shoot(caster.m_20154_());
        world.m_7967_((Entity)fireball);
    }

    public float getDamage(int spellLevel, LivingEntity caster) {
        return 5.0f + 5.0f * this.getSpellPower(spellLevel, (Entity)caster);
    }

    public int getRadius(int spellLevel, LivingEntity caster) {
        return 2 + (int)this.getSpellPower(spellLevel, (Entity)caster);
    }
}

