/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells;

import com.skydude.dacxirons.entity.spells.SunsWrath.SunsWrathAOE;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class SunsWrath
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "suns_wrath");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(10).setCooldownSeconds(25.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.aoe_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getHealing(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.duration", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel, caster), (int)1)}));
    }

    public SunsWrath() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 2;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 40;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.CLOUD_OF_REGEN_LOOP.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.15f, (boolean)false);
        return true;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData castTargetingData;
        LivingEntity target;
        Vec3 spawn = null;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (target = (castTargetingData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)world)) != null) {
            spawn = target.m_20182_();
        }
        if (spawn == null) {
            spawn = Utils.raycastForEntity((Level)world, (Entity)entity, (float)32.0f, (boolean)true, (float)0.15f).m_82450_();
            spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)spawn, (int)6);
        }
        int duration = this.getDuration(spellLevel, entity);
        float radius = this.getRadius(spellLevel, entity);
        SunsWrathAOE aoeEntity = new SunsWrathAOE(world);
        aoeEntity.m_5602_((Entity)entity);
        aoeEntity.setCircular();
        aoeEntity.setRadius(radius);
        aoeEntity.setDuration(duration);
        aoeEntity.setDamage(this.getHealing(spellLevel, entity));
        aoeEntity.m_146884_(spawn);
        aoeEntity.getParticle();
        TargetedAreaEntity visualEntity = TargetedAreaEntity.createTargetAreaEntity((Level)world, (Vec3)spawn, (float)radius, (int)0xFFFF00);
        visualEntity.setDuration(duration);
        visualEntity.setOwner((Entity)aoeEntity);
        visualEntity.setShouldFade(true);
        world.m_7967_((Entity)aoeEntity);
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getHealing(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.2f;
    }

    private float getRadius(int spellLevel, LivingEntity caster) {
        return 5.0f;
    }

    private int getDuration(int spellLevel, LivingEntity caster) {
        return (int)(200.0f + 10.0f * this.getSpellPower(spellLevel, (Entity)caster));
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ANIMATION_CONTINUOUS_OVERHEAD;
    }

    public Vector3f getTargetingColor() {
        return new Vector3f(1.0f, 1.0f, 0.0f);
    }
}

