/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells;

import com.skydude.dacxirons.entity.mobs.SummonedPyro;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class SummonPyroKnight
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "summon_pyro_knight");
    private final DefaultConfig defaultConfig = new DefaultConfig().setAllowCrafting(true).setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(6).setCooldownSeconds(150.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.summon_count", (Object[])new Object[]{1}), Component.m_237110_((String)"ui.dacxirons.summon_hp", (Object[])new Object[]{Math.round(this.getHealth(caster, spellLevel))}), Component.m_237110_((String)"ui.dacxirons.kamath.summon_duration", (Object[])new Object[]{Math.round((float)this.getDuration(caster, spellLevel) / 20.0f)}));
    }

    public SummonPyroKnight() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 3;
        this.castTime = 30;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_START.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_FINISH.get());
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float radius = 1.5f + 0.185f * (float)spellLevel;
        SummonedPyro pyro = new SummonedPyro(entity, true);
        int summonTime = this.getDuration(entity, spellLevel);
        pyro.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(pyro.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
        pyro.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, 0, false, false, false));
        float yrot = 6.281f + entity.m_146908_() * ((float)Math.PI / 180);
        Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)entity.m_146892_().m_82549_(new Vec3((double)(radius * Mth.m_14089_((float)yrot)), 0.0, (double)(radius * Mth.m_14031_((float)yrot)))), (int)10);
        pyro.m_21153_(this.getHealth(entity, spellLevel));
        pyro.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
        pyro.m_146922_(entity.m_146908_());
        pyro.m_146867_();
        world.m_7967_((Entity)pyro);
        int effectAmplifier = spellLevel - 1;
        if (entity.m_21023_((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public float getHealth(LivingEntity entity, int spellLevel) {
        return (float)(SummonedPyro.createAttributes().m_22265_().m_22245_(Attributes.f_22276_) * 0.005 * (double)this.getSpellPower(spellLevel, (Entity)entity));
    }

    public int getDuration(LivingEntity entity, int spellLevel) {
        return (int)(75.0f * this.getSpellPower(spellLevel, (Entity)entity));
    }
}

